/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.SearchContext;

public final class ParentFieldSubFetchPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (context.storedFieldsContext() != null && !context.storedFieldsContext().fetchFields()) {
            return;
        }
        ParentFieldMapper parentFieldMapper = context.mapperService().documentMapper(hitContext.hit().type()).parentFieldMapper();
        if (!parentFieldMapper.active()) {
            return;
        }
        String parentId = ParentFieldSubFetchPhase.getParentId(parentFieldMapper, hitContext.reader(), hitContext.docId());
        if (parentId == null) {
            return;
        }
        Map<String, SearchHitField> fields = hitContext.hit().fieldsOrNull();
        if (fields == null) {
            fields = new HashMap<String, SearchHitField>();
            hitContext.hit().fields(fields);
        }
        fields.put("_parent", new InternalSearchHitField("_parent", Collections.singletonList(parentId)));
    }

    public static String getParentId(ParentFieldMapper fieldMapper, LeafReader reader, int docId) {
        try {
            SortedDocValues docValues = reader.getSortedDocValues(fieldMapper.name());
            BytesRef parentId = docValues.get(docId);
            return parentId.length > 0 ? parentId.utf8ToString() : null;
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }
}

