/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.InternalAggregation;

public class GeoPointParser {
    private final InternalAggregation.Type aggType;
    private final ParseField field;

    public GeoPointParser(InternalAggregation.Type aggType, ParseField field) {
        this.aggType = aggType;
        this.field = field;
    }

    public boolean token(String aggName, String currentFieldName, XContentParser.Token token, XContentParser parser, ParseFieldMatcher parseFieldMatcher, Map<ParseField, Object> otherOptions) throws IOException {
        if (!parseFieldMatcher.match(currentFieldName, this.field)) {
            return false;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            GeoPoint point = new GeoPoint();
            point.resetFromString(parser.text());
            otherOptions.put(this.field, point);
            return true;
        }
        if (token == XContentParser.Token.START_ARRAY) {
            double lat = Double.NaN;
            double lon = Double.NaN;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (Double.isNaN(lon)) {
                    lon = parser.doubleValue();
                    continue;
                }
                if (Double.isNaN(lat)) {
                    lat = parser.doubleValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "malformed [" + currentFieldName + "] geo point array in [" + aggName + "] " + this.aggType + " aggregation. a geo point array must be of the form [lon, lat]", new Object[0]);
            }
            GeoPoint point = new GeoPoint(lat, lon);
            otherOptions.put(this.field, point);
            return true;
        }
        if (token == XContentParser.Token.START_OBJECT) {
            double lat = Double.NaN;
            double lon = Double.NaN;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                if ("lat".equals(currentFieldName)) {
                    lat = parser.doubleValue();
                    continue;
                }
                if (!"lon".equals(currentFieldName)) continue;
                lon = parser.doubleValue();
            }
            if (Double.isNaN(lat) || Double.isNaN(lon)) {
                throw new ParsingException(parser.getTokenLocation(), "malformed [" + currentFieldName + "] geo point object. either [lat] or [lon] (or both) are missing in [" + aggName + "] " + this.aggType + " aggregation", new Object[0]);
            }
            GeoPoint point = new GeoPoint(lat, lon);
            otherOptions.put(this.field, point);
            return true;
        }
        return false;
    }
}

