/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg.models;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelBuilder;

public class HoltWintersModel
extends MovAvgModel {
    public static final String NAME = "holt_winters";
    public static final double DEFAULT_ALPHA = 0.3;
    public static final double DEFAULT_BETA = 0.1;
    public static final double DEFAULT_GAMMA = 0.3;
    public static final int DEFAULT_PERIOD = 1;
    public static final SeasonalityType DEFAULT_SEASONALITY_TYPE = SeasonalityType.ADDITIVE;
    public static final boolean DEFAULT_PAD = false;
    private final double alpha;
    private final double beta;
    private final double gamma;
    private final int period;
    private final SeasonalityType seasonalityType;
    private final boolean pad;
    private final double padding;
    public static final MovAvgModel.AbstractModelParser PARSER = new MovAvgModel.AbstractModelParser(){

        @Override
        public MovAvgModel parse(@Nullable Map<String, Object> settings, String pipelineName, int windowSize, ParseFieldMatcher parseFieldMatcher) throws ParseException {
            Object value;
            double alpha = this.parseDoubleParam(settings, "alpha", 0.3);
            double beta = this.parseDoubleParam(settings, "beta", 0.1);
            double gamma = this.parseDoubleParam(settings, "gamma", 0.3);
            int period = this.parseIntegerParam(settings, "period", 1);
            if (windowSize < 2 * period) {
                throw new ParseException("Field [window] must be at least twice as large as the period when using Holt-Winters.  Value provided was [" + windowSize + "], which is less than (2*period) == " + 2 * period, 0);
            }
            SeasonalityType seasonalityType = DEFAULT_SEASONALITY_TYPE;
            if (settings != null && (value = settings.get("type")) != null) {
                if (value instanceof String) {
                    seasonalityType = SeasonalityType.parse((String)value, parseFieldMatcher);
                    settings.remove("type");
                } else {
                    throw new ParseException("Parameter [type] must be a String, type `" + value.getClass().getSimpleName() + "` provided instead", 0);
                }
            }
            boolean pad = this.parseBoolParam(settings, "pad", seasonalityType.equals((Object)SeasonalityType.MULTIPLICATIVE));
            this.checkUnrecognizedParams(settings);
            return new HoltWintersModel(alpha, beta, gamma, period, seasonalityType, pad);
        }
    };

    public HoltWintersModel() {
        this(0.3, 0.1, 0.3, 1, DEFAULT_SEASONALITY_TYPE, false);
    }

    public HoltWintersModel(double alpha, double beta, double gamma, int period, SeasonalityType seasonalityType, boolean pad) {
        this.alpha = alpha;
        this.beta = beta;
        this.gamma = gamma;
        this.period = period;
        this.seasonalityType = seasonalityType;
        this.pad = pad;
        this.padding = this.inferPadding();
    }

    public HoltWintersModel(StreamInput in) throws IOException {
        this.alpha = in.readDouble();
        this.beta = in.readDouble();
        this.gamma = in.readDouble();
        this.period = in.readVInt();
        this.seasonalityType = SeasonalityType.readFrom(in);
        this.pad = in.readBoolean();
        this.padding = this.inferPadding();
    }

    private double inferPadding() {
        return this.seasonalityType.equals((Object)SeasonalityType.MULTIPLICATIVE) && this.pad ? 1.0E-10 : 0.0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.alpha);
        out.writeDouble(this.beta);
        out.writeDouble(this.gamma);
        out.writeVInt(this.period);
        this.seasonalityType.writeTo(out);
        out.writeBoolean(this.pad);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean minimizeByDefault() {
        return true;
    }

    @Override
    public boolean canBeMinimized() {
        return true;
    }

    @Override
    public MovAvgModel neighboringModel() {
        double newValue = Math.random();
        switch ((int)(Math.random() * 3.0)) {
            case 0: {
                return new HoltWintersModel(newValue, this.beta, this.gamma, this.period, this.seasonalityType, this.pad);
            }
            case 1: {
                return new HoltWintersModel(this.alpha, newValue, this.gamma, this.period, this.seasonalityType, this.pad);
            }
            case 2: {
                return new HoltWintersModel(this.alpha, this.beta, newValue, this.period, this.seasonalityType, this.pad);
            }
        }
        assert (false) : "Random value fell outside of range [0-2]";
        return new HoltWintersModel(newValue, this.beta, this.gamma, this.period, this.seasonalityType, this.pad);
    }

    @Override
    public MovAvgModel clone() {
        return new HoltWintersModel(this.alpha, this.beta, this.gamma, this.period, this.seasonalityType, this.pad);
    }

    @Override
    public boolean hasValue(int valuesAvailable) {
        return valuesAvailable >= this.period * 2;
    }

    @Override
    protected <T extends Number> double[] doPredict(Collection<T> values, int numPredictions) {
        return this.next(values, numPredictions);
    }

    @Override
    public <T extends Number> double next(Collection<T> values) {
        return this.next(values, 1)[0];
    }

    public <T extends Number> double[] next(Collection<T> values, int numForecasts) {
        int i;
        if (values.size() < this.period * 2) {
            throw new AggregationExecutionException("Holt-Winters aggregation requires at least (2 * period == 2 * " + this.period + " == " + 2 * this.period + ") data-points to function.  Only [" + values.size() + "] were provided.");
        }
        double s = 0.0;
        double b = 0.0;
        double last_b = 0.0;
        double[] seasonal = new double[values.size()];
        int counter = 0;
        double[] vs = new double[values.size()];
        for (Number v : values) {
            vs[counter] = v.doubleValue() + this.padding;
            ++counter;
        }
        for (i = 0; i < this.period; ++i) {
            s += vs[i];
            b += (vs[i + this.period] - vs[i]) / (double)this.period;
        }
        b /= (double)this.period;
        double last_s = s /= (double)this.period;
        if (Double.compare(s, 0.0) == 0 || Double.compare(s, -0.0) == 0) {
            Arrays.fill(seasonal, 0.0);
        } else {
            for (i = 0; i < this.period; ++i) {
                seasonal[i] = vs[i] / s;
            }
        }
        for (i = this.period; i < vs.length; ++i) {
            s = this.seasonalityType.equals((Object)SeasonalityType.MULTIPLICATIVE) ? this.alpha * (vs[i] / seasonal[i - this.period]) + (1.0 - this.alpha) * (last_s + last_b) : this.alpha * (vs[i] - seasonal[i - this.period]) + (1.0 - this.alpha) * (last_s + last_b);
            b = this.beta * (s - last_s) + (1.0 - this.beta) * last_b;
            seasonal[i] = this.seasonalityType.equals((Object)SeasonalityType.MULTIPLICATIVE) ? this.gamma * (vs[i] / (last_s + last_b)) + (1.0 - this.gamma) * seasonal[i - this.period] : this.gamma * (vs[i] - (last_s - last_b)) + (1.0 - this.gamma) * seasonal[i - this.period];
            last_s = s;
            last_b = b;
        }
        double[] forecastValues = new double[numForecasts];
        for (int i2 = 1; i2 <= numForecasts; ++i2) {
            int idx = values.size() - this.period + (i2 - 1) % this.period;
            forecastValues[i2 - 1] = this.seasonalityType.equals((Object)SeasonalityType.MULTIPLICATIVE) ? (s + (double)i2 * b) * seasonal[idx] : s + (double)i2 * b + seasonal[idx];
        }
        return forecastValues;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(MovAvgPipelineAggregationBuilder.MODEL.getPreferredName(), NAME);
        builder.startObject(MovAvgPipelineAggregationBuilder.SETTINGS.getPreferredName());
        builder.field("alpha", this.alpha);
        builder.field("beta", this.beta);
        builder.field("gamma", this.gamma);
        builder.field("period", this.period);
        builder.field("pad", this.pad);
        builder.field("type", this.seasonalityType.getName());
        builder.endObject();
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.alpha, this.beta, this.gamma, this.period, this.seasonalityType, this.pad});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HoltWintersModel other = (HoltWintersModel)obj;
        return Objects.equals(this.alpha, other.alpha) && Objects.equals(this.beta, other.beta) && Objects.equals(this.gamma, other.gamma) && Objects.equals(this.period, other.period) && Objects.equals((Object)this.seasonalityType, (Object)other.seasonalityType) && Objects.equals(this.pad, other.pad);
    }

    public static class HoltWintersModelBuilder
    implements MovAvgModelBuilder {
        private double alpha = 0.3;
        private double beta = 0.1;
        private double gamma = 0.3;
        private int period = 1;
        private SeasonalityType seasonalityType = DEFAULT_SEASONALITY_TYPE;
        private Boolean pad = null;

        public HoltWintersModelBuilder alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public HoltWintersModelBuilder beta(double beta) {
            this.beta = beta;
            return this;
        }

        public HoltWintersModelBuilder gamma(double gamma) {
            this.gamma = gamma;
            return this;
        }

        public HoltWintersModelBuilder period(int period) {
            this.period = period;
            return this;
        }

        public HoltWintersModelBuilder seasonalityType(SeasonalityType type) {
            this.seasonalityType = type;
            return this;
        }

        public HoltWintersModelBuilder pad(boolean pad) {
            this.pad = pad;
            return this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(MovAvgPipelineAggregationBuilder.MODEL.getPreferredName(), HoltWintersModel.NAME);
            builder.startObject(MovAvgPipelineAggregationBuilder.SETTINGS.getPreferredName());
            builder.field("alpha", this.alpha);
            builder.field("beta", this.beta);
            builder.field("gamma", this.gamma);
            builder.field("period", this.period);
            if (this.pad != null) {
                builder.field("pad", this.pad);
            }
            builder.field("type", this.seasonalityType.getName());
            builder.endObject();
            return builder;
        }

        @Override
        public MovAvgModel build() {
            boolean pad = this.pad == null ? this.seasonalityType == SeasonalityType.MULTIPLICATIVE : this.pad;
            return new HoltWintersModel(this.alpha, this.beta, this.gamma, this.period, this.seasonalityType, pad);
        }
    }

    public static enum SeasonalityType {
        ADDITIVE(0, "add"),
        MULTIPLICATIVE(1, "mult");

        private final byte id;
        private final ParseField parseField;

        @Nullable
        public static SeasonalityType parse(String text, ParseFieldMatcher parseFieldMatcher) {
            if (text == null) {
                return null;
            }
            SeasonalityType result = null;
            for (SeasonalityType policy : SeasonalityType.values()) {
                if (!parseFieldMatcher.match(text, policy.parseField)) continue;
                result = policy;
                break;
            }
            if (result == null) {
                ArrayList<String> validNames = new ArrayList<String>();
                for (SeasonalityType policy : SeasonalityType.values()) {
                    validNames.add(policy.getName());
                }
                throw new ElasticsearchParseException("failed to parse seasonality type [{}]. accepted values are [{}]", text, validNames);
            }
            return result;
        }

        private SeasonalityType(byte id, String name) {
            this.id = id;
            this.parseField = new ParseField(name, new String[0]);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.id);
        }

        public static SeasonalityType readFrom(StreamInput in) throws IOException {
            byte id = in.readByte();
            for (SeasonalityType seasonalityType : SeasonalityType.values()) {
                if (id != seasonalityType.id) continue;
                return seasonalityType;
            }
            throw new IllegalStateException("Unknown Seasonality Type with id [" + id + "]");
        }

        public String getName() {
            return this.parseField.getPreferredName();
        }
    }
}

