/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.cumulativesum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsParser;
import org.elasticsearch.search.aggregations.pipeline.cumulativesum.CumulativeSumPipelineAggregator;

public class CumulativeSumPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<CumulativeSumPipelineAggregationBuilder> {
    public static final String NAME = "cumulative_sum";
    private String format;

    public CumulativeSumPipelineAggregationBuilder(String name, String bucketsPath) {
        super(name, NAME, new String[]{bucketsPath});
    }

    public CumulativeSumPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
    }

    public CumulativeSumPipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
        return new CumulativeSumPipelineAggregator(this.name, this.bucketsPaths, this.formatter(), metaData);
    }

    @Override
    public void doValidate(AggregatorFactory<?> parent, AggregatorFactory<?>[] aggFactories, List<PipelineAggregationBuilder> pipelineAggregatorFactories) {
        if (this.bucketsPaths.length != 1) {
            throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
        }
        if (parent instanceof HistogramAggregatorFactory) {
            HistogramAggregatorFactory histoParent = (HistogramAggregatorFactory)parent;
            if (histoParent.minDocCount() != 0L) {
                throw new IllegalStateException("parent histogram of cumulative sum aggregation [" + this.name + "] must have min_doc_count of 0");
            }
        } else if (parent instanceof DateHistogramAggregatorFactory) {
            DateHistogramAggregatorFactory histoParent = (DateHistogramAggregatorFactory)parent;
            if (histoParent.minDocCount() != 0L) {
                throw new IllegalStateException("parent histogram of cumulative sum aggregation [" + this.name + "] must have min_doc_count of 0");
            }
        } else {
            throw new IllegalStateException("cumulative sum aggregation [" + this.name + "] must have a histogram or date_histogram as parent");
        }
    }

    @Override
    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(BucketMetricsParser.FORMAT.getPreferredName(), this.format);
        }
        return builder;
    }

    public static CumulativeSumPipelineAggregationBuilder parse(String pipelineAggregatorName, QueryParseContext context) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (context.getParseFieldMatcher().match(currentFieldName, PipelineAggregator.Parser.FORMAT)) {
                    format = parser.text();
                    continue;
                }
                if (context.getParseFieldMatcher().match(currentFieldName, PipelineAggregator.Parser.BUCKETS_PATH)) {
                    bucketsPaths = new String[]{parser.text()};
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (context.getParseFieldMatcher().match(currentFieldName, PipelineAggregator.Parser.BUCKETS_PATH)) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[paths.size()]);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " in [" + pipelineAggregatorName + "].", new Object[0]);
        }
        if (bucketsPaths == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + "] for derivative aggregation [" + pipelineAggregatorName + "]", new Object[0]);
        }
        CumulativeSumPipelineAggregationBuilder factory = new CumulativeSumPipelineAggregationBuilder(pipelineAggregatorName, (String)bucketsPaths[0]);
        if (format != null) {
            factory.format(format);
        }
        return factory;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.format);
    }

    @Override
    protected boolean doEquals(Object obj) {
        CumulativeSumPipelineAggregationBuilder other = (CumulativeSumPipelineAggregationBuilder)obj;
        return Objects.equals(this.format, other.format);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

