/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedNumericSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class DiversifiedAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource, DiversifiedAggregatorFactory> {
    private final int shardSize;
    private final int maxDocsPerValue;
    private final String executionHint;

    public DiversifiedAggregatorFactory(String name, InternalAggregation.Type type, ValuesSourceConfig<ValuesSource> config, int shardSize, int maxDocsPerValue, String executionHint, AggregationContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, type, config, context, parent, subFactoriesBuilder, metaData);
        this.shardSize = shardSize;
        this.maxDocsPerValue = maxDocsPerValue;
        this.executionHint = executionHint;
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (valuesSource instanceof ValuesSource.Numeric) {
            return new DiversifiedNumericSamplerAggregator(this.name, this.shardSize, this.factories, this.context, parent, pipelineAggregators, metaData, (ValuesSource.Numeric)valuesSource, this.maxDocsPerValue);
        }
        if (valuesSource instanceof ValuesSource.Bytes) {
            SamplerAggregator.ExecutionMode execution = null;
            if (this.executionHint != null) {
                execution = SamplerAggregator.ExecutionMode.fromString(this.executionHint, this.context.searchContext().parseFieldMatcher());
            }
            if (execution == null) {
                execution = SamplerAggregator.ExecutionMode.GLOBAL_ORDINALS;
            }
            if (execution.needsGlobalOrdinals() && !(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                execution = SamplerAggregator.ExecutionMode.MAP;
            }
            return execution.create(this.name, this.factories, this.shardSize, this.maxDocsPerValue, valuesSource, this.context, parent, pipelineAggregators, metaData);
        }
        throw new AggregationExecutionException("Sampler aggregation cannot be applied to field [" + this.config.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        final UnmappedSampler aggregation = new UnmappedSampler(this.name, pipelineAggregators, metaData);
        return new NonCollectingAggregator(this.name, this.context, parent, this.factories, pipelineAggregators, metaData){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }
}

