/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.geodistance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.geodistance.GeoDistanceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.GeoPointParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class GeoDistanceParser
extends AbstractValuesSourceParser.GeoPointValuesSourceParser {
    static final ParseField ORIGIN_FIELD = new ParseField("origin", "center", "point", "por");
    static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    static final ParseField DISTANCE_TYPE_FIELD = new ParseField("distance_type", new String[0]);
    private GeoPointParser geoPointParser = new GeoPointParser(GeoDistanceAggregationBuilder.TYPE, ORIGIN_FIELD);

    public GeoDistanceParser() {
        super(true, false);
    }

    protected GeoDistanceAggregationBuilder createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        GeoDistance distanceType;
        DistanceUnit unit;
        GeoPoint origin = (GeoPoint)otherOptions.get(ORIGIN_FIELD);
        GeoDistanceAggregationBuilder factory = new GeoDistanceAggregationBuilder(aggregationName, origin);
        List ranges = (List)otherOptions.get(RangeAggregator.RANGES_FIELD);
        for (Range range : ranges) {
            factory.addRange(range);
        }
        Boolean keyed = (Boolean)otherOptions.get(RangeAggregator.KEYED_FIELD);
        if (keyed != null) {
            factory.keyed(keyed);
        }
        if ((unit = (DistanceUnit)otherOptions.get(UNIT_FIELD)) != null) {
            factory.unit(unit);
        }
        if ((distanceType = (GeoDistance)otherOptions.get(DISTANCE_TYPE_FIELD)) != null) {
            factory.distanceType(distanceType);
        }
        return factory;
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (this.geoPointParser.token(aggregationName, currentFieldName, token, parser, context.getParseFieldMatcher(), otherOptions)) {
            return true;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            if (context.matchField(currentFieldName, UNIT_FIELD)) {
                DistanceUnit unit = DistanceUnit.fromString(parser.text());
                otherOptions.put(UNIT_FIELD, unit);
                return true;
            }
            if (context.matchField(currentFieldName, DISTANCE_TYPE_FIELD)) {
                GeoDistance distanceType = GeoDistance.fromString(parser.text());
                otherOptions.put(DISTANCE_TYPE_FIELD, distanceType);
                return true;
            }
        } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
            if (context.matchField(currentFieldName, RangeAggregator.KEYED_FIELD)) {
                boolean keyed = parser.booleanValue();
                otherOptions.put(RangeAggregator.KEYED_FIELD, keyed);
                return true;
            }
        } else if (token == XContentParser.Token.START_ARRAY && context.matchField(currentFieldName, RangeAggregator.RANGES_FIELD)) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                String fromAsStr = null;
                String toAsStr = null;
                double from = 0.0;
                double to = Double.POSITIVE_INFINITY;
                String key = null;
                String toOrFromOrKey = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        toOrFromOrKey = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.VALUE_NUMBER) {
                        if (context.matchField(toOrFromOrKey, Range.FROM_FIELD)) {
                            from = parser.doubleValue();
                            continue;
                        }
                        if (!context.matchField(toOrFromOrKey, Range.TO_FIELD)) continue;
                        to = parser.doubleValue();
                        continue;
                    }
                    if (token != XContentParser.Token.VALUE_STRING) continue;
                    if (context.matchField(toOrFromOrKey, Range.KEY_FIELD)) {
                        key = parser.text();
                        continue;
                    }
                    if (context.matchField(toOrFromOrKey, Range.FROM_FIELD)) {
                        fromAsStr = parser.text();
                        continue;
                    }
                    if (!context.matchField(toOrFromOrKey, Range.TO_FIELD)) continue;
                    toAsStr = parser.text();
                }
                if (fromAsStr != null || toAsStr != null) {
                    ranges.add(new Range(key, Double.parseDouble(fromAsStr), Double.parseDouble(toAsStr)));
                    continue;
                }
                ranges.add(new Range(key, from, to));
            }
            otherOptions.put(RangeAggregator.RANGES_FIELD, ranges);
            return true;
        }
        return false;
    }

    public static class Range
    extends RangeAggregator.Range {
        public Range(String key, Double from, Double to) {
            super(Range.key(key, from, to), from == null ? 0.0 : from, to);
        }

        public Range(StreamInput in) throws IOException {
            super(in.readOptionalString(), in.readDouble(), in.readDouble());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeDouble(this.from);
            out.writeDouble(this.to);
        }

        private static String key(String key, Double from, Double to) {
            if (key != null) {
                return key;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(from == null || from == 0.0 ? "*" : from);
            sb.append("-");
            sb.append(to == null || Double.isInfinite(to) ? "*" : to);
            return sb.toString();
        }
    }
}

