/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.date;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.joda.time.DateTime;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.range.AbstractRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.date.DateRangeAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.date.InternalDateRange;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class DateRangeAggregationBuilder
extends AbstractRangeBuilder<DateRangeAggregationBuilder, RangeAggregator.Range> {
    public static final String NAME = "date_range";
    static final InternalAggregation.Type TYPE = new InternalAggregation.Type("date_range");

    public DateRangeAggregationBuilder(String name) {
        super(name, InternalDateRange.FACTORY);
    }

    public DateRangeAggregationBuilder(StreamInput in) throws IOException {
        super(in, InternalDateRange.FACTORY, RangeAggregator.Range::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public DateRangeAggregationBuilder addRange(String key, String from, String to) {
        this.addRange(new RangeAggregator.Range(key, from, to));
        return this;
    }

    public DateRangeAggregationBuilder addRange(String from, String to) {
        return this.addRange(null, from, to);
    }

    public DateRangeAggregationBuilder addUnboundedTo(String key, String to) {
        this.addRange(new RangeAggregator.Range(key, null, to));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedTo(String to) {
        return this.addUnboundedTo(null, to);
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String key, String from) {
        this.addRange(new RangeAggregator.Range(key, from, null));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String from) {
        return this.addUnboundedFrom(null, from);
    }

    public DateRangeAggregationBuilder addRange(String key, double from, double to) {
        this.addRange(new RangeAggregator.Range(key, from, to));
        return this;
    }

    public DateRangeAggregationBuilder addRange(double from, double to) {
        return this.addRange(null, from, to);
    }

    public DateRangeAggregationBuilder addUnboundedTo(String key, double to) {
        this.addRange(new RangeAggregator.Range(key, null, to));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedTo(double to) {
        return this.addUnboundedTo(null, to);
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String key, double from) {
        this.addRange(new RangeAggregator.Range(key, from, null));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedFrom(double from) {
        return this.addUnboundedFrom(null, from);
    }

    public DateRangeAggregationBuilder addRange(String key, DateTime from, DateTime to) {
        this.addRange(new RangeAggregator.Range(key, this.convertDateTime(from), this.convertDateTime(to)));
        return this;
    }

    private Double convertDateTime(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.getMillis();
    }

    public DateRangeAggregationBuilder addRange(DateTime from, DateTime to) {
        return this.addRange(null, from, to);
    }

    public DateRangeAggregationBuilder addUnboundedTo(String key, DateTime to) {
        this.addRange(new RangeAggregator.Range(key, null, this.convertDateTime(to)));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedTo(DateTime to) {
        return this.addUnboundedTo(null, to);
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String key, DateTime from) {
        this.addRange(new RangeAggregator.Range(key, this.convertDateTime(from), null));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedFrom(DateTime from) {
        return this.addUnboundedFrom(null, from);
    }

    protected DateRangeAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        RangeAggregator.Range[] ranges = this.processRanges(context, config);
        return new DateRangeAggregatorFactory(this.name, this.type, config, ranges, this.keyed, this.rangeFactory, context, parent, subFactoriesBuilder, (Map<String, Object>)this.metaData);
    }
}

