/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class DateHistogramParser
extends AbstractValuesSourceParser.NumericValuesSourceParser {
    public DateHistogramParser() {
        super(true, true, true);
    }

    protected DateHistogramAggregationBuilder createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        InternalOrder order;
        Long minDocCount;
        Boolean keyed;
        ExtendedBounds extendedBounds;
        DateHistogramAggregationBuilder factory = new DateHistogramAggregationBuilder(aggregationName);
        Object interval = otherOptions.get(Histogram.INTERVAL_FIELD);
        if (interval == null) {
            throw new ParsingException(null, "Missing required field [interval] for histogram aggregation [" + aggregationName + "]", new Object[0]);
        }
        if (interval instanceof Long) {
            factory.interval((Long)interval);
        } else if (interval instanceof DateHistogramInterval) {
            factory.dateHistogramInterval((DateHistogramInterval)interval);
        } else {
            throw new IllegalStateException("Unexpected interval class: " + interval.getClass());
        }
        Long offset = (Long)otherOptions.get(Histogram.OFFSET_FIELD);
        if (offset != null) {
            factory.offset(offset);
        }
        if ((extendedBounds = (ExtendedBounds)otherOptions.get(ExtendedBounds.EXTENDED_BOUNDS_FIELD)) != null) {
            factory.extendedBounds(extendedBounds);
        }
        if ((keyed = (Boolean)otherOptions.get(Histogram.KEYED_FIELD)) != null) {
            factory.keyed(keyed);
        }
        if ((minDocCount = (Long)otherOptions.get(Histogram.MIN_DOC_COUNT_FIELD)) != null) {
            factory.minDocCount(minDocCount);
        }
        if ((order = (InternalOrder)otherOptions.get(Histogram.ORDER_FIELD)) != null) {
            factory.order(order);
        }
        return factory;
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (token.isValue()) {
            if (context.matchField(currentFieldName, Histogram.INTERVAL_FIELD)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    otherOptions.put(Histogram.INTERVAL_FIELD, new DateHistogramInterval(parser.text()));
                    return true;
                }
                otherOptions.put(Histogram.INTERVAL_FIELD, parser.longValue());
                return true;
            }
            if (context.matchField(currentFieldName, Histogram.MIN_DOC_COUNT_FIELD)) {
                otherOptions.put(Histogram.MIN_DOC_COUNT_FIELD, parser.longValue());
                return true;
            }
            if (context.matchField(currentFieldName, Histogram.KEYED_FIELD)) {
                otherOptions.put(Histogram.KEYED_FIELD, parser.booleanValue());
                return true;
            }
            if (context.matchField(currentFieldName, Histogram.OFFSET_FIELD)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    otherOptions.put(Histogram.OFFSET_FIELD, DateHistogramAggregationBuilder.parseStringOffset(parser.text()));
                    return true;
                }
                otherOptions.put(Histogram.OFFSET_FIELD, parser.longValue());
                return true;
            }
            return false;
        }
        if (token == XContentParser.Token.START_OBJECT) {
            if (context.matchField(currentFieldName, Histogram.ORDER_FIELD)) {
                InternalOrder order = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token != XContentParser.Token.VALUE_STRING) continue;
                    String dir = parser.text();
                    boolean asc = "asc".equals(dir);
                    if (!asc && !"desc".equals(dir)) {
                        throw new ParsingException(parser.getTokenLocation(), "Unknown order direction in aggregation [" + aggregationName + "]: [" + dir + "]. Should be either [asc] or [desc]", new Object[0]);
                    }
                    order = DateHistogramParser.resolveOrder(currentFieldName, asc);
                }
                otherOptions.put(Histogram.ORDER_FIELD, order);
                return true;
            }
            if (context.matchField(currentFieldName, ExtendedBounds.EXTENDED_BOUNDS_FIELD)) {
                try {
                    otherOptions.put(ExtendedBounds.EXTENDED_BOUNDS_FIELD, ExtendedBounds.PARSER.apply(parser, context::getParseFieldMatcher));
                }
                catch (Exception e) {
                    throw new ParsingException(parser.getTokenLocation(), "Error parsing [{}]", e, aggregationName);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static InternalOrder resolveOrder(String key, boolean asc) {
        if ("_key".equals(key) || "_time".equals(key)) {
            return (InternalOrder)(asc ? InternalOrder.KEY_ASC : InternalOrder.KEY_DESC);
        }
        if ("_count".equals(key)) {
            return (InternalOrder)(asc ? InternalOrder.COUNT_ASC : InternalOrder.COUNT_DESC);
        }
        return new InternalOrder.Aggregation(key, asc);
    }
}

