/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortingNumericDocValues;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridParams;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class GeoGridAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.GeoPoint, GeoGridAggregationBuilder> {
    public static final String NAME = "geohash_grid";
    private static final InternalAggregation.Type TYPE = new InternalAggregation.Type("geohash_grid");
    private int precision = 5;
    private int requiredSize = 10000;
    private int shardSize = -1;

    public GeoGridAggregationBuilder(String name) {
        super(name, TYPE, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
    }

    public GeoGridAggregationBuilder(StreamInput in) throws IOException {
        super(in, TYPE, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
        this.precision = in.readVInt();
        this.requiredSize = in.readVInt();
        this.shardSize = in.readVInt();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.precision);
        out.writeVInt(this.requiredSize);
        out.writeVInt(this.shardSize);
    }

    public GeoGridAggregationBuilder precision(int precision) {
        this.precision = GeoHashGridParams.checkPrecision(precision);
        return this;
    }

    public int precision() {
        return this.precision;
    }

    public GeoGridAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.requiredSize = size;
        return this;
    }

    public int size() {
        return this.requiredSize;
    }

    public GeoGridAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.shardSize = shardSize;
        return this;
    }

    public int shardSize() {
        return this.shardSize;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.GeoPoint, ?> innerBuild(AggregationContext context, ValuesSourceConfig<ValuesSource.GeoPoint> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        int shardSize = this.shardSize;
        int requiredSize = this.requiredSize;
        if (shardSize < 0) {
            shardSize = BucketUtils.suggestShardSideQueueSize(requiredSize, context.searchContext().numberOfShards());
        }
        if (requiredSize <= 0 || shardSize <= 0) {
            throw new ElasticsearchException("parameters [required_size] and [shard_size] must be >0 in geohash_grid aggregation [" + this.name + "].", new Object[0]);
        }
        if (shardSize < requiredSize) {
            shardSize = requiredSize;
        }
        return new GeoHashGridAggregatorFactory(this.name, this.type, config, this.precision, requiredSize, shardSize, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(GeoHashGridParams.FIELD_PRECISION.getPreferredName(), this.precision);
        builder.field(GeoHashGridParams.FIELD_SIZE.getPreferredName(), this.requiredSize);
        if (this.shardSize > -1) {
            builder.field(GeoHashGridParams.FIELD_SHARD_SIZE.getPreferredName(), this.shardSize);
        }
        return builder;
    }

    @Override
    protected boolean innerEquals(Object obj) {
        GeoGridAggregationBuilder other = (GeoGridAggregationBuilder)obj;
        if (this.precision != other.precision) {
            return false;
        }
        if (this.requiredSize != other.requiredSize) {
            return false;
        }
        return this.shardSize == other.shardSize;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.precision, this.requiredSize, this.shardSize);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    static class CellIdSource
    extends ValuesSource.Numeric {
        private final ValuesSource.GeoPoint valuesSource;
        private final int precision;

        public CellIdSource(ValuesSource.GeoPoint valuesSource, int precision) {
            this.valuesSource = valuesSource;
            this.precision = precision;
        }

        public int precision() {
            return this.precision;
        }

        @Override
        public boolean isFloatingPoint() {
            return false;
        }

        @Override
        public SortedNumericDocValues longValues(LeafReaderContext ctx) {
            return new CellValues(this.valuesSource.geoPointValues(ctx), this.precision);
        }

        @Override
        public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }
    }

    private static class CellValues
    extends SortingNumericDocValues {
        private MultiGeoPointValues geoValues;
        private int precision;

        protected CellValues(MultiGeoPointValues geoValues, int precision) {
            this.geoValues = geoValues;
            this.precision = precision;
        }

        @Override
        public void setDocument(int docId) {
            this.geoValues.setDocument(docId);
            this.resize(this.geoValues.count());
            for (int i = 0; i < this.count(); ++i) {
                GeoPoint target = this.geoValues.valueAt(i);
                this.values[i] = GeoHashUtils.longEncode(target.getLon(), target.getLat(), this.precision);
            }
            this.sort();
        }
    }
}

