/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class RestCountAction
extends AbstractCatAction {
    private final IndicesQueriesRegistry indicesQueriesRegistry;

    @Inject
    public RestCountAction(Settings settings, RestController restController, RestController controller, IndicesQueriesRegistry indicesQueriesRegistry) {
        super(settings);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/count", this);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/count/{index}", this);
        this.indicesQueriesRegistry = indicesQueriesRegistry;
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/count\n");
        sb.append("/_cat/count/{index}\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        SearchRequest countRequest = new SearchRequest(indices);
        String source = request.param("source");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0);
        countRequest.source(searchSourceBuilder);
        if (source != null) {
            searchSourceBuilder.query(RestActions.getQueryContent(new BytesArray(source), this.indicesQueriesRegistry, this.parseFieldMatcher));
        } else {
            QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
            if (queryBuilder != null) {
                searchSourceBuilder.query(queryBuilder);
            }
        }
        return channel -> client.search(countRequest, (ActionListener<SearchResponse>)new RestResponseListener<SearchResponse>(channel){

            @Override
            public RestResponse buildResponse(SearchResponse countResponse) throws Exception {
                return RestTable.buildResponse(RestCountAction.this.buildTable(request, countResponse), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeadersWithTimestamp();
        table.addCell("count", "alias:dc,docs.count,docsCount;desc:the document count");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, SearchResponse response) {
        Table table = this.getTableWithHeader(request);
        table.startRow();
        table.addCell(response.getHits().totalHits());
        table.endRow();
        return table;
    }
}

