/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.admin.cluster.RestListTasksAction;
import org.elasticsearch.tasks.TaskId;

public class RestCancelTasksAction
extends BaseRestHandler {
    private final ClusterService clusterService;

    @Inject
    public RestCancelTasksAction(Settings settings, RestController controller, ClusterService clusterService) {
        super(settings);
        this.clusterService = clusterService;
        controller.registerHandler(RestRequest.Method.POST, "/_tasks/_cancel", this);
        controller.registerHandler(RestRequest.Method.POST, "/_tasks/{task_id}/_cancel", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodes"));
        TaskId taskId = new TaskId(request.param("task_id"));
        String[] actions = Strings.splitStringByCommaToArray(request.param("actions"));
        TaskId parentTaskId = new TaskId(request.param("parent_task_id"));
        String groupBy = request.param("group_by", "nodes");
        CancelTasksRequest cancelTasksRequest = new CancelTasksRequest();
        cancelTasksRequest.setTaskId(taskId);
        cancelTasksRequest.setNodes(nodesIds);
        cancelTasksRequest.setActions(actions);
        cancelTasksRequest.setParentTaskId(parentTaskId);
        return channel -> client.admin().cluster().cancelTasks(cancelTasksRequest, RestListTasksAction.listTasksResponseListener(this.clusterService, groupBy, channel));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

