/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node.service;

import java.io.Closeable;
import java.io.IOException;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class NodeService
extends AbstractComponent
implements Closeable {
    private final ThreadPool threadPool;
    private final MonitorService monitorService;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final PluginsService pluginService;
    private final CircuitBreakerService circuitBreakerService;
    private final IngestService ingestService;
    private final SettingsFilter settingsFilter;
    private ScriptService scriptService;
    @Nullable
    private final HttpServer httpServer;
    private final Discovery discovery;

    @Inject
    public NodeService(Settings settings, ThreadPool threadPool, MonitorService monitorService, Discovery discovery, TransportService transportService, IndicesService indicesService, PluginsService pluginService, CircuitBreakerService circuitBreakerService, ScriptService scriptService, @Nullable HttpServer httpServer, IngestService ingestService, ClusterService clusterService, SettingsFilter settingsFilter) {
        super(settings);
        this.threadPool = threadPool;
        this.monitorService = monitorService;
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.discovery = discovery;
        this.pluginService = pluginService;
        this.circuitBreakerService = circuitBreakerService;
        this.httpServer = httpServer;
        this.ingestService = ingestService;
        this.settingsFilter = settingsFilter;
        this.scriptService = scriptService;
        clusterService.add(ingestService.getPipelineStore());
        clusterService.add(ingestService.getPipelineExecutionService());
    }

    public NodeInfo info(boolean settings, boolean os, boolean process, boolean jvm, boolean threadPool, boolean transport, boolean http, boolean plugin, boolean ingest, boolean indices) {
        return new NodeInfo(Version.CURRENT, Build.CURRENT, this.discovery.localNode(), settings ? this.settingsFilter.filter(this.settings) : null, os ? this.monitorService.osService().info() : null, process ? this.monitorService.processService().info() : null, jvm ? this.monitorService.jvmService().info() : null, threadPool ? this.threadPool.info() : null, transport ? this.transportService.info() : null, http ? (this.httpServer == null ? null : this.httpServer.info()) : null, plugin ? (this.pluginService == null ? null : this.pluginService.info()) : null, ingest ? (this.ingestService == null ? null : this.ingestService.info()) : null, indices ? this.indicesService.getTotalIndexingBufferBytes() : null);
    }

    public NodeStats stats(CommonStatsFlags indices, boolean os, boolean process, boolean jvm, boolean threadPool, boolean fs, boolean transport, boolean http, boolean circuitBreaker, boolean script, boolean discoveryStats, boolean ingest) {
        return new NodeStats(this.discovery.localNode(), System.currentTimeMillis(), indices.anySet() ? this.indicesService.stats(true, indices) : null, os ? this.monitorService.osService().stats() : null, process ? this.monitorService.processService().stats() : null, jvm ? this.monitorService.jvmService().stats() : null, threadPool ? this.threadPool.stats() : null, fs ? this.monitorService.fsService().stats() : null, transport ? this.transportService.stats() : null, http ? (this.httpServer == null ? null : this.httpServer.stats()) : null, circuitBreaker ? this.circuitBreakerService.stats() : null, script ? this.scriptService.stats() : null, discoveryStats ? this.discovery.stats() : null, ingest ? this.ingestService.getPipelineExecutionService().stats() : null);
    }

    public IngestService getIngestService() {
        return this.ingestService;
    }

    @Override
    public void close() throws IOException {
        this.indicesService.close();
    }
}

