/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;

public class StoreFileMetaData
implements Writeable {
    public static final Version FIRST_LUCENE_CHECKSUM_VERSION = Version.LUCENE_5_0_0;
    private final String name;
    private final long length;
    private final String checksum;
    private final Version writtenBy;
    private final BytesRef hash;

    public StoreFileMetaData(String name, long length, String checksum) {
        this(name, length, checksum, FIRST_LUCENE_CHECKSUM_VERSION);
    }

    public StoreFileMetaData(String name, long length, String checksum, Version writtenBy) {
        this(name, length, checksum, writtenBy, null);
    }

    public StoreFileMetaData(String name, long length, String checksum, Version writtenBy, BytesRef hash) {
        assert (name.startsWith("segments_") || writtenBy != null && writtenBy.onOrAfter(FIRST_LUCENE_CHECKSUM_VERSION)) : "index version less that " + FIRST_LUCENE_CHECKSUM_VERSION + " are not supported but got: " + writtenBy;
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.length = length;
        this.checksum = Objects.requireNonNull(checksum, "checksum must not be null");
        this.writtenBy = Objects.requireNonNull(writtenBy, "writtenBy must not be null");
        this.hash = hash == null ? new BytesRef() : hash;
    }

    public StoreFileMetaData(StreamInput in) throws IOException {
        this.name = in.readString();
        this.length = in.readVLong();
        this.checksum = in.readString();
        this.writtenBy = Lucene.parseVersionLenient(in.readString(), FIRST_LUCENE_CHECKSUM_VERSION);
        this.hash = in.readBytesRef();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVLong(this.length);
        out.writeString(this.checksum);
        out.writeString(this.writtenBy.toString());
        out.writeBytesRef(this.hash);
    }

    public String name() {
        return this.name;
    }

    public long length() {
        return this.length;
    }

    public String checksum() {
        return this.checksum;
    }

    public boolean isSame(StoreFileMetaData other) {
        if (this.checksum == null || other.checksum == null) {
            return false;
        }
        return this.length == other.length && this.checksum.equals(other.checksum) && this.hash.equals(other.hash);
    }

    public String toString() {
        return "name [" + this.name + "], length [" + this.length + "], checksum [" + this.checksum + "], writtenBy [" + this.writtenBy + "]";
    }

    public Version writtenBy() {
        return this.writtenBy;
    }

    public BytesRef hash() {
        return this.hash;
    }
}

