/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.StoreRateLimiting;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;

public class IndexStoreConfig {
    public static final Setting<StoreRateLimiting.Type> INDICES_STORE_THROTTLE_TYPE_SETTING = new Setting<StoreRateLimiting.Type>("indices.store.throttle.type", StoreRateLimiting.Type.NONE.name(), StoreRateLimiting.Type::fromString, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> INDICES_STORE_THROTTLE_MAX_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("indices.store.throttle.max_bytes_per_sec", new ByteSizeValue(0L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile StoreRateLimiting.Type rateLimitingType;
    private volatile ByteSizeValue rateLimitingThrottle;
    private final StoreRateLimiting rateLimiting = new StoreRateLimiting();
    private final Logger logger;

    public IndexStoreConfig(Settings settings) {
        this.logger = Loggers.getLogger(IndexStoreConfig.class, settings, new String[0]);
        this.rateLimitingType = INDICES_STORE_THROTTLE_TYPE_SETTING.get(settings);
        this.rateLimiting.setType(this.rateLimitingType);
        this.rateLimitingThrottle = INDICES_STORE_THROTTLE_MAX_BYTES_PER_SEC_SETTING.get(settings);
        this.rateLimiting.setMaxRate(this.rateLimitingThrottle);
        this.logger.debug("using indices.store.throttle.type [{}], with index.store.throttle.max_bytes_per_sec [{}]", (Object)this.rateLimitingType, (Object)this.rateLimitingThrottle);
    }

    public StoreRateLimiting getNodeRateLimiter() {
        return this.rateLimiting;
    }

    public void setRateLimitingType(StoreRateLimiting.Type rateLimitingType) {
        this.rateLimitingType = rateLimitingType;
        this.rateLimiting.setType(rateLimitingType);
    }

    public void setRateLimitingThrottle(ByteSizeValue rateLimitingThrottle) {
        this.rateLimitingThrottle = rateLimitingThrottle;
    }
}

