/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.similarity.BM25SimilarityProvider;
import org.elasticsearch.index.similarity.ClassicSimilarityProvider;
import org.elasticsearch.index.similarity.DFISimilarityProvider;
import org.elasticsearch.index.similarity.DFRSimilarityProvider;
import org.elasticsearch.index.similarity.IBSimilarityProvider;
import org.elasticsearch.index.similarity.LMDirichletSimilarityProvider;
import org.elasticsearch.index.similarity.LMJelinekMercerSimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityProvider;

public final class SimilarityService
extends AbstractIndexComponent {
    public static final String DEFAULT_SIMILARITY = "BM25";
    private final Similarity defaultSimilarity;
    private final Similarity baseSimilarity;
    private final Map<String, SimilarityProvider> similarities;
    static final Map<String, BiFunction<String, Settings, SimilarityProvider>> DEFAULTS;
    public static final Map<String, BiFunction<String, Settings, SimilarityProvider>> BUILT_IN;

    public SimilarityService(IndexSettings indexSettings, Map<String, BiFunction<String, Settings, SimilarityProvider>> similarities) {
        super(indexSettings);
        HashMap<String, SimilarityProvider> providers = new HashMap<String, SimilarityProvider>(similarities.size());
        Map<String, Settings> similaritySettings = this.indexSettings.getSettings().getGroups("index.similarity");
        for (Map.Entry<String, Settings> entry : similaritySettings.entrySet()) {
            String name = entry.getKey();
            if (BUILT_IN.containsKey(name) && indexSettings.getIndexVersionCreated().onOrAfter(Version.V_5_0_0_alpha1)) {
                throw new IllegalArgumentException("Cannot redefine built-in Similarity [" + name + "]");
            }
            Settings settings = entry.getValue();
            String typeName = settings.get("type");
            if (typeName == null) {
                throw new IllegalArgumentException("Similarity [" + name + "] must have an associated type");
            }
            if (!(similarities.containsKey(typeName) || BUILT_IN.containsKey(typeName))) {
                throw new IllegalArgumentException("Unknown Similarity type [" + typeName + "] for [" + name + "]");
            }
            BiFunction<String, Settings, SimilarityProvider> factory = similarities.getOrDefault(typeName, BUILT_IN.get(typeName));
            if (settings == null) {
                settings = Settings.Builder.EMPTY_SETTINGS;
            }
            providers.put(name, factory.apply(name, settings));
        }
        for (Map.Entry<String, Object> entry : this.addSimilarities(similaritySettings, DEFAULTS).entrySet()) {
            if (providers.containsKey(entry.getKey()) && indexSettings.getIndexVersionCreated().before(Version.V_5_0_0_alpha1)) continue;
            providers.put(entry.getKey(), (SimilarityProvider)entry.getValue());
        }
        this.similarities = providers;
        this.defaultSimilarity = providers.get("default") != null ? ((SimilarityProvider)providers.get("default")).get() : ((SimilarityProvider)providers.get(DEFAULT_SIMILARITY)).get();
        this.baseSimilarity = providers.get("base") != null ? ((SimilarityProvider)providers.get("base")).get() : this.defaultSimilarity;
    }

    public Similarity similarity(MapperService mapperService) {
        return mapperService != null ? new PerFieldSimilarity(this.defaultSimilarity, this.baseSimilarity, mapperService) : this.defaultSimilarity;
    }

    private Map<String, SimilarityProvider> addSimilarities(Map<String, Settings> similaritySettings, Map<String, BiFunction<String, Settings, SimilarityProvider>> similarities) {
        HashMap<String, SimilarityProvider> providers = new HashMap<String, SimilarityProvider>(similarities.size());
        for (Map.Entry<String, BiFunction<String, Settings, SimilarityProvider>> entry : similarities.entrySet()) {
            String name = entry.getKey();
            BiFunction<String, Settings, SimilarityProvider> factory = entry.getValue();
            Settings settings = similaritySettings.get(name);
            if (settings == null) {
                settings = Settings.Builder.EMPTY_SETTINGS;
            }
            providers.put(name, factory.apply(name, settings));
        }
        return providers;
    }

    public SimilarityProvider getSimilarity(String name) {
        return this.similarities.get(name);
    }

    Similarity getDefaultSimilarity() {
        return this.defaultSimilarity;
    }

    static {
        HashMap<String, BiFunction<String, Settings, SimilarityProvider>> defaults = new HashMap<String, BiFunction<String, Settings, SimilarityProvider>>();
        HashMap<String, BiFunction<String, Settings, SimilarityProvider>> buildIn = new HashMap<String, BiFunction<String, Settings, SimilarityProvider>>();
        defaults.put("classic", ClassicSimilarityProvider::new);
        defaults.put(DEFAULT_SIMILARITY, BM25SimilarityProvider::new);
        buildIn.put("classic", ClassicSimilarityProvider::new);
        buildIn.put(DEFAULT_SIMILARITY, BM25SimilarityProvider::new);
        buildIn.put("DFR", DFRSimilarityProvider::new);
        buildIn.put("IB", IBSimilarityProvider::new);
        buildIn.put("LMDirichlet", LMDirichletSimilarityProvider::new);
        buildIn.put("LMJelinekMercer", LMJelinekMercerSimilarityProvider::new);
        buildIn.put("DFI", DFISimilarityProvider::new);
        DEFAULTS = Collections.unmodifiableMap(defaults);
        BUILT_IN = Collections.unmodifiableMap(buildIn);
    }

    static class PerFieldSimilarity
    extends PerFieldSimilarityWrapper {
        private final Similarity defaultSimilarity;
        private final MapperService mapperService;

        PerFieldSimilarity(Similarity defaultSimilarity, Similarity baseSimilarity, MapperService mapperService) {
            super(baseSimilarity);
            this.defaultSimilarity = defaultSimilarity;
            this.mapperService = mapperService;
        }

        @Override
        public Similarity get(String name) {
            MappedFieldType fieldType = this.mapperService.fullName(name);
            return fieldType != null && fieldType.similarity() != null ? fieldType.similarity().get() : this.defaultSimilarity;
        }
    }
}

