/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ReferenceManager;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.index.translog.Translog;

public final class RefreshListeners
implements ReferenceManager.RefreshListener {
    private final IntSupplier getMaxRefreshListeners;
    private final Runnable forceRefresh;
    private final Executor listenerExecutor;
    private final Logger logger;
    private volatile List<Tuple<Translog.Location, Consumer<Boolean>>> refreshListeners = null;
    private volatile Translog.Location lastRefreshedLocation;
    private Translog translog;
    private Translog.Location currentRefreshLocation;

    public RefreshListeners(IntSupplier getMaxRefreshListeners, Runnable forceRefresh, Executor listenerExecutor, Logger logger) {
        this.getMaxRefreshListeners = getMaxRefreshListeners;
        this.forceRefresh = forceRefresh;
        this.listenerExecutor = listenerExecutor;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrNotify(Translog.Location location, Consumer<Boolean> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(location, "location cannot be null");
        if (this.lastRefreshedLocation != null && this.lastRefreshedLocation.compareTo(location) >= 0) {
            listener.accept(false);
            return true;
        }
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
            }
            if (this.refreshListeners.size() < this.getMaxRefreshListeners.getAsInt()) {
                this.refreshListeners.add(new Tuple<Translog.Location, Consumer<Boolean>>(location, listener));
                return false;
            }
        }
        this.forceRefresh.run();
        listener.accept(true);
        return true;
    }

    public boolean refreshNeeded() {
        return this.refreshListeners != null;
    }

    public void setTranslog(Translog translog) {
        this.translog = translog;
    }

    @Override
    public void beforeRefresh() throws IOException {
        this.currentRefreshLocation = this.translog.getLastWriteLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRefresh(boolean didRefresh) throws IOException {
        List<Tuple<Translog.Location, Consumer<Boolean>>> candidates;
        if (null == this.currentRefreshLocation) {
            return;
        }
        this.lastRefreshedLocation = this.currentRefreshLocation;
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            candidates = this.refreshListeners;
            if (candidates == null) {
                return;
            }
            this.refreshListeners = null;
        }
        ArrayList<Consumer<Boolean>> listenersToFire = null;
        ArrayList<Tuple<Translog.Location, Consumer<Boolean>>> preservedListeners = null;
        for (Tuple<Translog.Location, Consumer<Boolean>> tuple : candidates) {
            Translog.Location location = tuple.v1();
            Consumer<Boolean> listener = tuple.v2();
            if (location.compareTo(this.currentRefreshLocation) <= 0) {
                if (listenersToFire == null) {
                    listenersToFire = new ArrayList<Consumer<Boolean>>();
                }
                listenersToFire.add(listener);
                continue;
            }
            if (preservedListeners == null) {
                preservedListeners = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
            }
            preservedListeners.add(tuple);
        }
        if (preservedListeners != null) {
            RefreshListeners refreshListeners2 = this;
            synchronized (refreshListeners2) {
                if (this.refreshListeners == null) {
                    this.refreshListeners = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
                }
                this.refreshListeners.addAll(preservedListeners);
            }
        }
        if (listenersToFire != null) {
            ArrayList<Consumer<Boolean>> finalListenersToFire = listenersToFire;
            this.listenerExecutor.execute(() -> {
                for (Consumer listener : finalListenersToFire) {
                    try {
                        listener.accept(false);
                    }
                    catch (Exception e) {
                        this.logger.warn("Error firing refresh listener", (Throwable)e);
                    }
                }
            });
        }
    }
}

