/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;

class ParentBulkByScrollTask
extends BulkByScrollTask {
    private final AtomicArray<Tuple<BulkIndexByScrollResponse, Exception>> results;
    private final AtomicInteger counter;

    public ParentBulkByScrollTask(long id, String type, String action, String description, TaskId parentTaskId, int slices) {
        super(id, type, action, description, parentTaskId);
        this.results = new AtomicArray(slices);
        this.counter = new AtomicInteger(slices);
    }

    @Override
    void rethrottle(float newRequestsPerSecond) {
    }

    @Override
    public BulkByScrollTask.Status getStatus() {
        List<BulkByScrollTask.StatusOrException> statuses = Arrays.asList(new BulkByScrollTask.StatusOrException[this.results.length()]);
        this.addResultsToList(statuses);
        return new BulkByScrollTask.Status(Collections.unmodifiableList(statuses), this.getReasonCancelled());
    }

    @Override
    int runningSliceSubTasks() {
        return this.counter.get();
    }

    @Override
    public TaskInfo getInfoGivenSliceInfo(String localNodeId, List<TaskInfo> sliceInfo) {
        List<BulkByScrollTask.StatusOrException> sliceStatuses = Arrays.asList(new BulkByScrollTask.StatusOrException[this.results.length()]);
        for (TaskInfo t : sliceInfo) {
            BulkByScrollTask.Status status = (BulkByScrollTask.Status)t.getStatus();
            sliceStatuses.set(status.getSliceId(), new BulkByScrollTask.StatusOrException(status));
        }
        this.addResultsToList(sliceStatuses);
        BulkByScrollTask.Status status = new BulkByScrollTask.Status(sliceStatuses, this.getReasonCancelled());
        return this.taskInfo(localNodeId, this.getDescription(), status);
    }

    private void addResultsToList(List<BulkByScrollTask.StatusOrException> sliceStatuses) {
        for (AtomicArray.Entry<Tuple<BulkIndexByScrollResponse, Exception>> t : this.results.asList()) {
            if (t.value == null) continue;
            if (((Tuple)t.value).v1() != null) {
                sliceStatuses.set(t.index, new BulkByScrollTask.StatusOrException(((BulkIndexByScrollResponse)((Tuple)t.value).v1()).getStatus()));
                continue;
            }
            sliceStatuses.set(t.index, new BulkByScrollTask.StatusOrException((Exception)((Tuple)t.value).v2()));
        }
    }

    void onSliceResponse(ActionListener<BulkIndexByScrollResponse> listener, int sliceId, BulkIndexByScrollResponse response) {
        this.results.setOnce(sliceId, new Tuple<BulkIndexByScrollResponse, Object>(response, null));
        this.recordSliceCompletionAndRespondIfAllDone(listener);
    }

    void onSliceFailure(ActionListener<BulkIndexByScrollResponse> listener, int sliceId, Exception e) {
        this.results.setOnce(sliceId, new Tuple<Object, Exception>(null, e));
        this.recordSliceCompletionAndRespondIfAllDone(listener);
    }

    private void recordSliceCompletionAndRespondIfAllDone(ActionListener<BulkIndexByScrollResponse> listener) {
        if (this.counter.decrementAndGet() != 0) {
            return;
        }
        ArrayList<BulkIndexByScrollResponse> responses = new ArrayList<BulkIndexByScrollResponse>(this.results.length());
        Exception exception = null;
        for (AtomicArray.Entry<Tuple<BulkIndexByScrollResponse, Exception>> t : this.results.asList()) {
            if (((Tuple)t.value).v1() == null) {
                assert (((Tuple)t.value).v2() != null) : "exception shouldn't be null if value is null";
                if (exception == null) {
                    exception = (Exception)((Tuple)t.value).v2();
                    continue;
                }
                exception.addSuppressed((Throwable)((Tuple)t.value).v2());
                continue;
            }
            assert (((Tuple)t.value).v2() == null) : "exception should be null if response is not null";
            responses.add((BulkIndexByScrollResponse)((Tuple)t.value).v1());
        }
        if (exception == null) {
            listener.onResponse(new BulkIndexByScrollResponse(responses, this.getReasonCancelled()));
        } else {
            listener.onFailure(exception);
        }
    }
}

