/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BitSet;
import org.elasticsearch.Version;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointArrayLegacyAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class GeoPointArrayIndexFieldData
extends AbstractIndexGeoPointFieldData {
    private final CircuitBreakerService breakerService;

    public GeoPointArrayIndexFieldData(IndexSettings indexSettings, String fieldName, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(indexSettings, fieldName, cache);
        this.breakerService = breakerService;
    }

    @Override
    public AtomicGeoPointFieldData loadDirect(LeafReaderContext context) throws Exception {
        LeafReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldName());
        AtomicGeoPointFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker("fielddata"));
        if (terms == null) {
            data = AbstractAtomicGeoPointFieldData.empty(reader.maxDoc());
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        return this.indexSettings.getIndexVersionCreated().before(Version.V_2_2_0) ? this.loadLegacyFieldData(reader, estimator, terms, data) : this.loadFieldData22(reader, estimator, terms, data);
    }

    /*
     * Loose catch block
     */
    private AtomicGeoPointFieldData loadFieldData22(LeafReader reader, NonEstimatingEstimator estimator, Terms terms, AtomicGeoPointFieldData data) throws Exception {
        LongArray indexedPoints = BigArrays.NON_RECYCLING_INSTANCE.newLongArray(128L);
        float acceptableTransientOverheadRatio = 0.5f;
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(reader.maxDoc(), 0.5f);){
                Long hashedPoint;
                TermsEnum termsEnum;
                GeoPointField.TermEncoding termEncoding;
                if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_2_3_0)) {
                    termEncoding = GeoPointField.TermEncoding.PREFIX;
                    termsEnum = OrdinalsBuilder.wrapGeoPointTerms(terms.iterator());
                } else {
                    termEncoding = GeoPointField.TermEncoding.NUMERIC;
                    termsEnum = OrdinalsBuilder.wrapNumeric64Bit(terms.iterator());
                }
                AbstractIndexGeoPointFieldData.GeoPointTermsEnum iter = new AbstractIndexGeoPointFieldData.GeoPointTermsEnum(builder.buildFromTerms(termsEnum), termEncoding);
                long numTerms = 0L;
                while ((hashedPoint = iter.next()) != null) {
                    indexedPoints = BigArrays.NON_RECYCLING_INSTANCE.resize(indexedPoints, numTerms + 1L);
                    indexedPoints.set(numTerms++, hashedPoint);
                }
                indexedPoints = BigArrays.NON_RECYCLING_INSTANCE.resize(indexedPoints, numTerms);
                Ordinals build = builder.build();
                RandomAccessOrds ordinals = build.ordinals();
                if (!FieldData.isMultiValued(ordinals)) {
                    int maxDoc = reader.maxDoc();
                    LongArray sIndexedPoint = BigArrays.NON_RECYCLING_INSTANCE.newLongArray(reader.maxDoc());
                    for (int i = 0; i < maxDoc; ++i) {
                        ordinals.setDocument(i);
                        long nativeOrdinal = ordinals.nextOrd();
                        if (nativeOrdinal == -1L) continue;
                        sIndexedPoint.set(i, indexedPoints.get(nativeOrdinal));
                    }
                    BitSet set = builder.buildDocsWithValuesSet();
                    data = new GeoPointArrayAtomicFieldData.Single(sIndexedPoint, set);
                } else {
                    data = new GeoPointArrayAtomicFieldData.WithOrdinals(indexedPoints, build, reader.maxDoc());
                }
                success = true;
                AtomicGeoPointFieldData atomicGeoPointFieldData = data;
                return atomicGeoPointFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.ramBytesUsed());
            }
        }
    }

    /*
     * Loose catch block
     */
    private AtomicGeoPointFieldData loadLegacyFieldData(LeafReader reader, NonEstimatingEstimator estimator, Terms terms, AtomicGeoPointFieldData data) throws Exception {
        DoubleArray lat = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(128L);
        DoubleArray lon = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(128L);
        float acceptableTransientOverheadRatio = 0.5f;
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(reader.maxDoc(), 0.5f);){
                GeoPoint point;
                AbstractIndexGeoPointFieldData.GeoPointTermsEnumLegacy iter = new AbstractIndexGeoPointFieldData.GeoPointTermsEnumLegacy(builder.buildFromTerms(terms.iterator()));
                long numTerms = 0L;
                while ((point = iter.next()) != null) {
                    lat = BigArrays.NON_RECYCLING_INSTANCE.resize(lat, numTerms + 1L);
                    lon = BigArrays.NON_RECYCLING_INSTANCE.resize(lon, numTerms + 1L);
                    lat.set(numTerms, point.getLat());
                    lon.set(numTerms, point.getLon());
                    ++numTerms;
                }
                lat = BigArrays.NON_RECYCLING_INSTANCE.resize(lat, numTerms);
                lon = BigArrays.NON_RECYCLING_INSTANCE.resize(lon, numTerms);
                Ordinals build = builder.build();
                RandomAccessOrds ordinals = build.ordinals();
                if (!FieldData.isMultiValued(ordinals)) {
                    int maxDoc = reader.maxDoc();
                    DoubleArray sLat = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(reader.maxDoc());
                    DoubleArray sLon = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(reader.maxDoc());
                    for (int i = 0; i < maxDoc; ++i) {
                        ordinals.setDocument(i);
                        long nativeOrdinal = ordinals.nextOrd();
                        if (nativeOrdinal == -1L) continue;
                        sLat.set(i, lat.get(nativeOrdinal));
                        sLon.set(i, lon.get(nativeOrdinal));
                    }
                    BitSet set = builder.buildDocsWithValuesSet();
                    data = new GeoPointArrayLegacyAtomicFieldData.Single(sLon, sLat, set);
                } else {
                    data = new GeoPointArrayLegacyAtomicFieldData.WithOrdinals(lon, lat, build, reader.maxDoc());
                }
                success = true;
                AtomicGeoPointFieldData atomicGeoPointFieldData = data;
                return atomicGeoPointFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.ramBytesUsed());
            }
        }
    }
}

