/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.CharsRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.LegacyNumericUtils;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.search.MultiValueMode;

abstract class AbstractIndexGeoPointFieldData
extends AbstractIndexFieldData<AtomicGeoPointFieldData>
implements IndexGeoPointFieldData {
    public AbstractIndexGeoPointFieldData(IndexSettings indexSettings, String fieldName, IndexFieldDataCache cache) {
        super(indexSettings, fieldName, cache);
    }

    @Override
    public final IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    @Override
    protected AtomicGeoPointFieldData empty(int maxDoc) {
        return AbstractAtomicGeoPointFieldData.empty(maxDoc);
    }

    protected static class GeoPointTermsEnumLegacy
    extends BaseGeoPointTermsEnum {
        private final GeoPoint next = new GeoPoint();
        private final CharsRefBuilder spare = new CharsRefBuilder();

        protected GeoPointTermsEnumLegacy(BytesRefIterator termsEnum) {
            super(termsEnum);
        }

        public GeoPoint next() throws IOException {
            BytesRef term = this.termsEnum.next();
            if (term == null) {
                return null;
            }
            this.spare.copyUTF8Bytes(term);
            int commaIndex = -1;
            for (int i = 0; i < this.spare.length(); ++i) {
                if (this.spare.charAt(i) != ',') continue;
                commaIndex = i;
                break;
            }
            if (commaIndex == -1) {
                assert (false);
                return this.next.reset(0.0, 0.0);
            }
            double lat = Double.parseDouble(new String(this.spare.chars(), 0, commaIndex));
            double lon = Double.parseDouble(new String(this.spare.chars(), commaIndex + 1, this.spare.length() - (commaIndex + 1)));
            return this.next.reset(lat, lon);
        }
    }

    protected static class GeoPointTermsEnum
    extends BaseGeoPointTermsEnum {
        private final GeoPointField.TermEncoding termEncoding;

        protected GeoPointTermsEnum(BytesRefIterator termsEnum, GeoPointField.TermEncoding termEncoding) {
            super(termsEnum);
            this.termEncoding = termEncoding;
        }

        public Long next() throws IOException {
            BytesRef term = this.termsEnum.next();
            if (term == null) {
                return null;
            }
            if (this.termEncoding == GeoPointField.TermEncoding.PREFIX) {
                return GeoPointField.prefixCodedToGeoCoded(term);
            }
            if (this.termEncoding == GeoPointField.TermEncoding.NUMERIC) {
                return LegacyNumericUtils.prefixCodedToLong(term);
            }
            throw new IllegalArgumentException("GeoPoint.TermEncoding should be one of: " + (Object)((Object)GeoPointField.TermEncoding.PREFIX) + " or " + (Object)((Object)GeoPointField.TermEncoding.NUMERIC) + " found: " + (Object)((Object)this.termEncoding));
        }
    }

    protected static abstract class BaseGeoPointTermsEnum {
        protected final BytesRefIterator termsEnum;

        protected BaseGeoPointTermsEnum(BytesRefIterator termsEnum) {
            this.termsEnum = termsEnum;
        }
    }
}

