/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.ObjectLongHashMap;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class FieldDataStats
implements Streamable,
ToXContent {
    long memorySize;
    long evictions;
    @Nullable
    ObjectLongHashMap<String> fields;

    public FieldDataStats() {
    }

    public FieldDataStats(long memorySize, long evictions, @Nullable ObjectLongHashMap<String> fields) {
        this.memorySize = memorySize;
        this.evictions = evictions;
        this.fields = fields;
    }

    public void add(FieldDataStats stats) {
        this.memorySize += stats.memorySize;
        this.evictions += stats.evictions;
        if (stats.fields != null) {
            if (this.fields == null) {
                this.fields = stats.fields.clone();
            } else {
                assert (!stats.fields.containsKey(null));
                Object[] keys = stats.fields.keys;
                long[] values = stats.fields.values;
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] == null) continue;
                    this.fields.addTo((String)keys[i], values[i]);
                }
            }
        }
    }

    public long getMemorySizeInBytes() {
        return this.memorySize;
    }

    public ByteSizeValue getMemorySize() {
        return new ByteSizeValue(this.memorySize);
    }

    public long getEvictions() {
        return this.evictions;
    }

    @Nullable
    public ObjectLongHashMap<String> getFields() {
        return this.fields;
    }

    public static FieldDataStats readFieldDataStats(StreamInput in) throws IOException {
        FieldDataStats stats = new FieldDataStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.memorySize = in.readVLong();
        this.evictions = in.readVLong();
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.fields = new ObjectLongHashMap(size);
            for (int i = 0; i < size; ++i) {
                this.fields.put(in.readString(), in.readVLong());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.memorySize);
        out.writeVLong(this.evictions);
        if (this.fields == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.fields.size());
            assert (!this.fields.containsKey(null));
            Object[] keys = this.fields.keys;
            long[] values = this.fields.values;
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                out.writeString((String)keys[i]);
                out.writeVLong(values[i]);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("fielddata");
        builder.byteSizeField("memory_size_in_bytes", "memory_size", this.memorySize);
        builder.field("evictions", this.getEvictions());
        if (this.fields != null) {
            builder.startObject("fields");
            assert (!this.fields.containsKey(null));
            Object[] keys = this.fields.keys;
            long[] values = this.fields.values;
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                builder.startObject((String)keys[i]);
                builder.byteSizeField("memory_size_in_bytes", "memory_size", values[i]);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String FIELDDATA = "fielddata";
        static final String MEMORY_SIZE = "memory_size";
        static final String MEMORY_SIZE_IN_BYTES = "memory_size_in_bytes";
        static final String EVICTIONS = "evictions";
        static final String FIELDS = "fields";

        Fields() {
        }
    }
}

