/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.analysis.PreBuiltTokenizers;

public class PreBuiltTokenizerFactoryFactory
implements AnalysisModule.AnalysisProvider<TokenizerFactory> {
    private final TokenizerFactory tokenizerFactory;

    public PreBuiltTokenizerFactoryFactory(TokenizerFactory tokenizerFactory) {
        this.tokenizerFactory = tokenizerFactory;
    }

    @Override
    public TokenizerFactory get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        PreBuiltTokenizers preBuiltTokenizers;
        Version indexVersion = Version.indexCreated(settings);
        if (!Version.CURRENT.equals(indexVersion) && (preBuiltTokenizers = PreBuiltTokenizers.getOrDefault(name, null)) != null) {
            return preBuiltTokenizers.getTokenizerFactory(indexVersion);
        }
        return this.tokenizerFactory;
    }
}

