/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.analysis.PreBuiltCharFilters;

public class PreBuiltCharFilterFactoryFactory
implements AnalysisModule.AnalysisProvider<CharFilterFactory> {
    private final CharFilterFactory charFilterFactory;

    public PreBuiltCharFilterFactoryFactory(CharFilterFactory charFilterFactory) {
        this.charFilterFactory = charFilterFactory;
    }

    @Override
    public CharFilterFactory get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        PreBuiltCharFilters preBuiltCharFilters;
        Version indexVersion = Version.indexCreated(settings);
        if (!Version.CURRENT.equals(indexVersion) && (preBuiltCharFilters = PreBuiltCharFilters.getOrDefault(name, null)) != null) {
            return preBuiltCharFilters.getCharFilterFactory(indexVersion);
        }
        return this.charFilterFactory;
    }
}

