/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.CharArraySet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.commongrams.CommonGramsQueryFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;

public class CommonGramsTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet words;
    private final boolean ignoreCase;
    private final boolean queryMode;

    public CommonGramsTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", false);
        this.queryMode = settings.getAsBoolean("query_mode", false);
        this.words = Analysis.parseCommonWords(env, settings, null, this.ignoreCase);
        if (this.words == null) {
            throw new IllegalArgumentException("missing or empty [common_words] or [common_words_path] configuration for common_grams token filter");
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        CommonGramsFilter filter = new CommonGramsFilter(tokenStream, this.words);
        if (this.queryMode) {
            return new CommonGramsQueryFilter(filter);
        }
        return filter;
    }
}

