/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.IOUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexWarmer;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexSearcherWrapper;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.index.shard.ShadowIndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexService
extends AbstractIndexComponent
implements IndicesClusterStateService.AllocatedIndex<IndexShard> {
    private final IndexEventListener eventListener;
    private final IndexFieldDataService indexFieldData;
    private final BitsetFilterCache bitsetFilterCache;
    private final NodeEnvironment nodeEnv;
    private final ShardStoreDeleter shardStoreDeleter;
    private final IndexStore indexStore;
    private final IndexSearcherWrapper searcherWrapper;
    private final IndexCache indexCache;
    private final MapperService mapperService;
    private final SimilarityService similarityService;
    private final EngineFactory engineFactory;
    private final IndexWarmer warmer;
    private volatile Map<Integer, IndexShard> shards = Collections.emptyMap();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean deleted = new AtomicBoolean(false);
    private final IndexSettings indexSettings;
    private final List<IndexingOperationListener> indexingOperationListeners;
    private final List<SearchOperationListener> searchOperationListeners;
    private volatile AsyncRefreshTask refreshTask;
    private volatile AsyncTranslogFSync fsyncTask;
    private final ThreadPool threadPool;
    private final BigArrays bigArrays;
    private final ScriptService scriptService;
    private final IndicesQueriesRegistry queryRegistry;
    private final ClusterService clusterService;
    private final Client client;

    public IndexService(IndexSettings indexSettings, NodeEnvironment nodeEnv, SimilarityService similarityService, ShardStoreDeleter shardStoreDeleter, AnalysisRegistry registry, @Nullable EngineFactory engineFactory, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, ScriptService scriptService, IndicesQueriesRegistry queryRegistry, ClusterService clusterService, Client client, QueryCache queryCache, IndexStore indexStore, IndexEventListener eventListener, IndexModule.IndexSearcherWrapperFactory wrapperFactory, MapperRegistry mapperRegistry, IndicesFieldDataCache indicesFieldDataCache, List<SearchOperationListener> searchOperationListeners, List<IndexingOperationListener> indexingOperationListeners) throws IOException {
        super(indexSettings);
        this.indexSettings = indexSettings;
        this.similarityService = similarityService;
        this.mapperService = new MapperService(indexSettings, registry.build(indexSettings), similarityService, mapperRegistry, () -> this.newQueryShardContext(0, null, () -> {
            throw new IllegalArgumentException("Percolator queries are not allowed to use the current timestamp");
        }));
        this.indexFieldData = new IndexFieldDataService(indexSettings, indicesFieldDataCache, circuitBreakerService, this.mapperService);
        this.shardStoreDeleter = shardStoreDeleter;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.scriptService = scriptService;
        this.queryRegistry = queryRegistry;
        this.clusterService = clusterService;
        this.client = client;
        this.eventListener = eventListener;
        this.nodeEnv = nodeEnv;
        this.indexStore = indexStore;
        this.indexFieldData.setListener(new FieldDataCacheListener(this));
        this.bitsetFilterCache = new BitsetFilterCache(indexSettings, new BitsetCacheListener(this));
        this.warmer = new IndexWarmer(indexSettings.getSettings(), threadPool, this.bitsetFilterCache.createListener(threadPool));
        this.indexCache = new IndexCache(indexSettings, queryCache, this.bitsetFilterCache);
        this.engineFactory = engineFactory;
        this.searcherWrapper = wrapperFactory.newWrapper(this);
        this.indexingOperationListeners = Collections.unmodifiableList(indexingOperationListeners);
        this.searchOperationListeners = Collections.unmodifiableList(searchOperationListeners);
        this.refreshTask = new AsyncRefreshTask(this);
        this.rescheduleFsyncTask(indexSettings.getTranslogDurability());
    }

    public int numberOfShards() {
        return this.shards.size();
    }

    public IndexEventListener getIndexEventListener() {
        return this.eventListener;
    }

    @Override
    public Iterator<IndexShard> iterator() {
        return this.shards.values().iterator();
    }

    public boolean hasShard(int shardId) {
        return this.shards.containsKey(shardId);
    }

    @Override
    @Nullable
    public IndexShard getShardOrNull(int shardId) {
        return this.shards.get(shardId);
    }

    public IndexShard getShard(int shardId) {
        IndexShard indexShard = this.getShardOrNull(shardId);
        if (indexShard == null) {
            throw new ShardNotFoundException(new ShardId(this.index(), shardId));
        }
        return indexShard;
    }

    public Set<Integer> shardIds() {
        return this.shards.keySet();
    }

    public IndexCache cache() {
        return this.indexCache;
    }

    public IndexFieldDataService fieldData() {
        return this.indexFieldData;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public SimilarityService similarityService() {
        return this.similarityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(String reason, boolean delete) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.deleted.compareAndSet(false, delete);
            try {
                Set<Integer> shardIds = this.shardIds();
                for (int shardId : shardIds) {
                    try {
                        this.removeShard(shardId, reason);
                    }
                    catch (Exception e) {
                        this.logger.warn("failed to close shard", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(this.bitsetFilterCache, this.indexCache, this.indexFieldData, this.mapperService, this.refreshTask, this.fsyncTask);
                throw throwable;
            }
            IOUtils.close(this.bitsetFilterCache, this.indexCache, this.indexFieldData, this.mapperService, this.refreshTask, this.fsyncTask);
        }
    }

    public String indexUUID() {
        return this.indexSettings.getUUID();
    }

    private long getAvgShardSizeInBytes() throws IOException {
        long sum = 0L;
        int count = 0;
        for (IndexShard indexShard : this) {
            sum += indexShard.store().stats().sizeInBytes();
            ++count;
        }
        if (count == 0) {
            return -1L;
        }
        return sum / (long)count;
    }

    public synchronized IndexShard createShard(ShardRouting routing) throws IOException {
        IndexShard indexShard;
        block16: {
            IndexShard indexShard2;
            Store store;
            ShardId shardId;
            block17: {
                boolean primary = routing.primary();
                if (this.closed.get()) {
                    throw new IllegalStateException("Can't create shard " + routing.shardId() + ", closed");
                }
                Settings indexSettings = this.indexSettings.getSettings();
                shardId = routing.shardId();
                boolean success = false;
                store = null;
                indexShard2 = null;
                ShardLock lock = null;
                try {
                    ShardPath path;
                    lock = this.nodeEnv.shardLock(shardId, TimeUnit.SECONDS.toMillis(5L));
                    this.eventListener.beforeIndexShardCreated(shardId, indexSettings);
                    try {
                        path = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, this.indexSettings);
                    }
                    catch (IllegalStateException ex) {
                        this.logger.warn("{} failed to load shard path, trying to remove leftover", (Object)shardId);
                        try {
                            ShardPath.deleteLeftoverShardDirectory(this.logger, this.nodeEnv, lock, this.indexSettings);
                            path = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, this.indexSettings);
                        }
                        catch (Exception inner) {
                            ex.addSuppressed(inner);
                            throw ex;
                        }
                    }
                    if (path == null) {
                        HashMap<Path, Integer> dataPathToShardCount = new HashMap<Path, Integer>();
                        for (IndexShard shard : this) {
                            Path dataPath = shard.shardPath().getRootStatePath();
                            Integer curCount = (Integer)dataPathToShardCount.get(dataPath);
                            if (curCount == null) {
                                curCount = 0;
                            }
                            dataPathToShardCount.put(dataPath, curCount + 1);
                        }
                        path = ShardPath.selectNewPathForShard(this.nodeEnv, shardId, this.indexSettings, routing.getExpectedShardSize() == -1L ? this.getAvgShardSizeInBytes() : routing.getExpectedShardSize(), dataPathToShardCount);
                        this.logger.debug("{} creating using a new path [{}]", (Object)shardId, (Object)path);
                    } else {
                        this.logger.debug("{} creating using an existing path [{}]", (Object)shardId, (Object)path);
                    }
                    if (this.shards.containsKey(shardId.id())) {
                        throw new IllegalStateException(shardId + " already exists");
                    }
                    this.logger.debug("creating shard_id {}", (Object)shardId);
                    boolean canDeleteShardContent = !IndexMetaData.isOnSharedFilesystem(indexSettings) || primary && IndexMetaData.isOnSharedFilesystem(indexSettings);
                    Engine.Warmer engineWarmer = searcher -> {
                        IndexShard shard = this.getShardOrNull(shardId.getId());
                        if (shard != null) {
                            this.warmer.warm(searcher, shard, this.indexSettings);
                        }
                    };
                    store = new Store(shardId, this.indexSettings, this.indexStore.newDirectoryService(path), lock, new StoreCloseListener(shardId, canDeleteShardContent, () -> this.eventListener.onStoreClosed(shardId)));
                    indexShard2 = IndexService.useShadowEngine(primary, indexSettings) ? new ShadowIndexShard(routing, this.indexSettings, path, store, this.indexCache, this.mapperService, this.similarityService, this.indexFieldData, this.engineFactory, this.eventListener, this.searcherWrapper, this.threadPool, this.bigArrays, engineWarmer, this.searchOperationListeners) : new IndexShard(routing, this.indexSettings, path, store, this.indexCache, this.mapperService, this.similarityService, this.indexFieldData, this.engineFactory, this.eventListener, this.searcherWrapper, this.threadPool, this.bigArrays, engineWarmer, this.searchOperationListeners, this.indexingOperationListeners);
                    this.eventListener.indexShardStateChanged(indexShard2, null, indexShard2.state(), "shard created");
                    this.eventListener.afterIndexShardCreated(indexShard2);
                    this.shards = MapBuilder.newMapBuilder(this.shards).put(shardId.id(), indexShard2).immutableMap();
                    success = true;
                    indexShard = indexShard2;
                    if (success) break block16;
                    if (lock == null) break block17;
                }
                catch (ShardLockObtainFailedException e) {
                    try {
                        throw new IOException("failed to obtain in-memory shard lock", e);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            if (lock != null) {
                                IOUtils.closeWhileHandlingException(lock);
                            }
                            this.closeShard("initialization failed", shardId, indexShard2, store, this.eventListener);
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeWhileHandlingException(lock);
            }
            this.closeShard("initialization failed", shardId, indexShard2, store, this.eventListener);
        }
        return indexShard;
    }

    static boolean useShadowEngine(boolean primary, Settings indexSettings) {
        return !primary && IndexMetaData.isIndexUsingShadowReplicas(indexSettings);
    }

    @Override
    public synchronized void removeShard(int shardId, String reason) {
        ShardId sId = new ShardId(this.index(), shardId);
        if (!this.shards.containsKey(shardId)) {
            return;
        }
        this.logger.debug("[{}] closing... (reason: [{}])", (Object)shardId, (Object)reason);
        HashMap<Integer, IndexShard> newShards = new HashMap<Integer, IndexShard>(this.shards);
        IndexShard indexShard = newShards.remove(shardId);
        this.shards = Collections.unmodifiableMap(newShards);
        this.closeShard(reason, sId, indexShard, indexShard.store(), indexShard.getIndexEventListener());
        this.logger.debug("[{}] closed (reason: [{}])", (Object)shardId, (Object)reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeShard(String reason, ShardId sId, IndexShard indexShard, Store store, IndexEventListener listener) {
        int shardId = sId.id();
        Settings indexSettings = this.getIndexSettings().getSettings();
        try {
            block16: {
                try {
                    listener.beforeIndexShardClosed(sId, indexShard, indexSettings);
                    if (indexShard == null) break block16;
                }
                catch (Throwable throwable) {
                    if (indexShard != null) {
                        try {
                            boolean flushEngine = !this.deleted.get() && this.closed.get();
                            indexShard.close(reason, flushEngine);
                        }
                        catch (Exception e) {
                            this.logger.debug(() -> new ParameterizedMessage("[{}] failed to close index shard", (Object)shardId), (Throwable)e);
                        }
                    }
                    listener.afterIndexShardClosed(sId, indexShard, indexSettings);
                    throw throwable;
                }
                try {
                    boolean flushEngine = !this.deleted.get() && this.closed.get();
                    indexShard.close(reason, flushEngine);
                }
                catch (Exception e) {
                    this.logger.debug(() -> new ParameterizedMessage("[{}] failed to close index shard", (Object)shardId), (Throwable)e);
                }
            }
            listener.afterIndexShardClosed(sId, indexShard, indexSettings);
        }
        finally {
            try {
                if (store != null) {
                    store.close();
                } else {
                    this.logger.trace("[{}] store not initialized prior to closing shard, nothing to close", (Object)shardId);
                }
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to close store on shard removal (reason: [{}])", (Object)shardId, (Object)reason), (Throwable)e);
            }
        }
    }

    private void onShardClose(ShardLock lock, boolean ownsShard) {
        block6: {
            if (this.deleted.get()) {
                try {
                    if (!ownsShard) break block6;
                    try {
                        this.eventListener.beforeIndexShardDeleted(lock.getShardId(), this.indexSettings.getSettings());
                    }
                    finally {
                        this.shardStoreDeleter.deleteShardStore("delete index", lock, this.indexSettings);
                        this.eventListener.afterIndexShardDeleted(lock.getShardId(), this.indexSettings.getSettings());
                    }
                }
                catch (IOException e) {
                    this.shardStoreDeleter.addPendingDelete(lock.getShardId(), this.indexSettings);
                    this.logger.debug(() -> new ParameterizedMessage("[{}] failed to delete shard content - scheduled a retry", (Object)lock.getShardId().id()), (Throwable)e);
                }
            }
        }
    }

    @Override
    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public QueryShardContext newQueryShardContext(int shardId, IndexReader indexReader, LongSupplier nowInMillis) {
        return new QueryShardContext(shardId, this.indexSettings, this.indexCache.bitsetFilterCache(), this.indexFieldData, this.mapperService(), this.similarityService(), this.scriptService, this.queryRegistry, this.client, indexReader, this.clusterService.state(), nowInMillis);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public BigArrays getBigArrays() {
        return this.bigArrays;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    List<IndexingOperationListener> getIndexOperationListeners() {
        return this.indexingOperationListeners;
    }

    List<SearchOperationListener> getSearchOperationListener() {
        return this.searchOperationListeners;
    }

    @Override
    public boolean updateMapping(IndexMetaData indexMetaData) throws IOException {
        return this.mapperService().updateMapping(indexMetaData);
    }

    public IndexMetaData getMetaData() {
        return this.indexSettings.getIndexMetaData();
    }

    @Override
    public synchronized void updateMetaData(IndexMetaData metadata) {
        Translog.Durability oldTranslogDurability = this.indexSettings.getTranslogDurability();
        if (this.indexSettings.updateIndexMetaData(metadata)) {
            Translog.Durability durability;
            for (IndexShard shard : this.shards.values()) {
                try {
                    shard.onSettingsChanged();
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("[{}] failed to notify shard about setting change", (Object)shard.shardId().id()), (Throwable)e);
                }
            }
            if (!this.refreshTask.getInterval().equals(this.indexSettings.getRefreshInterval())) {
                this.rescheduleRefreshTasks();
            }
            if ((durability = this.indexSettings.getTranslogDurability()) != oldTranslogDurability) {
                this.rescheduleFsyncTask(durability);
            }
        }
        for (IndexShard shard : this.shards.values()) {
            shard.updatePrimaryTerm(metadata.primaryTerm(shard.shardId().id()));
        }
    }

    private void rescheduleFsyncTask(Translog.Durability durability) {
        try {
            if (this.fsyncTask != null) {
                this.fsyncTask.close();
            }
            this.fsyncTask = durability == Translog.Durability.REQUEST ? null : new AsyncTranslogFSync(this);
        }
        catch (Throwable throwable) {
            this.fsyncTask = durability == Translog.Durability.REQUEST ? null : new AsyncTranslogFSync(this);
            throw throwable;
        }
    }

    private void rescheduleRefreshTasks() {
        try {
            this.refreshTask.close();
        }
        finally {
            this.refreshTask = new AsyncRefreshTask(this);
        }
    }

    final EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    final IndexSearcherWrapper getSearcherWrapper() {
        return this.searcherWrapper;
    }

    final IndexStore getIndexStore() {
        return this.indexStore;
    }

    private void maybeFSyncTranslogs() {
        if (this.indexSettings.getTranslogDurability() == Translog.Durability.ASYNC) {
            for (IndexShard shard : this.shards.values()) {
                try {
                    Translog translog = shard.getTranslog();
                    if (!translog.syncNeeded()) continue;
                    translog.sync();
                }
                catch (AlreadyClosedException | EngineClosedException translog) {
                }
                catch (IOException e) {
                    this.logger.warn("failed to sync translog", (Throwable)e);
                }
            }
        }
    }

    private void maybeRefreshEngine() {
        if (this.indexSettings.getRefreshInterval().millis() > 0L) {
            block6: for (IndexShard shard : this.shards.values()) {
                switch (shard.state()) {
                    case CREATED: 
                    case RECOVERING: 
                    case CLOSED: {
                        continue block6;
                    }
                    case POST_RECOVERY: 
                    case STARTED: 
                    case RELOCATED: {
                        try {
                            if (!shard.isRefreshNeeded()) continue block6;
                            shard.refresh("schedule");
                        }
                        catch (AlreadyClosedException | IndexShardClosedException runtimeException) {}
                        continue block6;
                    }
                }
                throw new IllegalStateException("unknown state: " + (Object)((Object)shard.state()));
            }
        }
    }

    AsyncRefreshTask getRefreshTask() {
        return this.refreshTask;
    }

    AsyncTranslogFSync getFsyncTask() {
        return this.fsyncTask;
    }

    final class AsyncRefreshTask
    extends BaseAsyncTask {
        AsyncRefreshTask(IndexService indexService) {
            super(indexService, indexService.getIndexSettings().getRefreshInterval());
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeRefreshEngine();
        }

        @Override
        protected String getThreadPool() {
            return "refresh";
        }

        public String toString() {
            return "refresh";
        }
    }

    static final class AsyncTranslogFSync
    extends BaseAsyncTask {
        AsyncTranslogFSync(IndexService indexService) {
            super(indexService, indexService.getIndexSettings().getTranslogSyncInterval());
        }

        @Override
        protected String getThreadPool() {
            return "flush";
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeFSyncTranslogs();
        }

        public String toString() {
            return "translog_sync";
        }
    }

    static abstract class BaseAsyncTask
    implements Runnable,
    Closeable {
        protected final IndexService indexService;
        protected final ThreadPool threadPool;
        private final TimeValue interval;
        private ScheduledFuture<?> scheduledFuture;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private volatile Exception lastThrownException;

        BaseAsyncTask(IndexService indexService, TimeValue interval) {
            this.indexService = indexService;
            this.threadPool = indexService.getThreadPool();
            this.interval = interval;
            this.onTaskCompletion();
        }

        boolean mustReschedule() {
            return !this.indexService.closed.get() && !this.closed.get() && this.interval.millis() > 0L;
        }

        private synchronized void onTaskCompletion() {
            if (this.mustReschedule()) {
                if (this.indexService.logger.isTraceEnabled()) {
                    this.indexService.logger.trace("scheduling {} every {}", (Object)this.toString(), (Object)this.interval);
                }
                this.scheduledFuture = this.threadPool.schedule(this.interval, this.getThreadPool(), this);
            } else {
                this.indexService.logger.trace("scheduled {} disabled", (Object)this.toString());
                this.scheduledFuture = null;
            }
        }

        boolean isScheduled() {
            return this.scheduledFuture != null;
        }

        @Override
        public final void run() {
            try {
                this.runInternal();
            }
            catch (Exception ex) {
                if (this.lastThrownException == null || !BaseAsyncTask.sameException(this.lastThrownException, ex)) {
                    this.indexService.logger.warn(() -> new ParameterizedMessage("failed to run task {} - suppressing re-occurring exceptions unless the exception changes", (Object)this.toString()), (Throwable)ex);
                    this.lastThrownException = ex;
                }
            }
            finally {
                this.onTaskCompletion();
            }
        }

        private static boolean sameException(Exception left, Exception right) {
            StackTraceElement[] stackTraceRight;
            StackTraceElement[] stackTraceLeft;
            if (left.getClass() == right.getClass() && Objects.equals(left.getMessage(), right.getMessage()) && (stackTraceLeft = left.getStackTrace()).length == (stackTraceRight = right.getStackTrace()).length) {
                for (int i = 0; i < stackTraceLeft.length; ++i) {
                    if (stackTraceLeft[i].equals(stackTraceRight[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        protected abstract void runInternal();

        protected String getThreadPool() {
            return "same";
        }

        @Override
        public synchronized void close() {
            if (this.closed.compareAndSet(false, true)) {
                FutureUtils.cancel(this.scheduledFuture);
                this.scheduledFuture = null;
            }
        }

        TimeValue getInterval() {
            return this.interval;
        }

        boolean isClosed() {
            return this.closed.get();
        }
    }

    public static interface ShardStoreDeleter {
        public void deleteShardStore(String var1, ShardLock var2, IndexSettings var3) throws IOException;

        public void addPendingDelete(ShardId var1, IndexSettings var2);
    }

    private final class FieldDataCacheListener
    implements IndexFieldDataCache.Listener {
        final IndexService indexService;

        public FieldDataCacheListener(IndexService indexService2) {
            this.indexService = indexService2;
        }

        @Override
        public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                shard.fieldData().onCache(shardId, fieldName, ramUsage);
            }
        }

        @Override
        public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                shard.fieldData().onRemoval(shardId, fieldName, wasEvicted, sizeInBytes);
            }
        }
    }

    private static final class BitsetCacheListener
    implements BitsetFilterCache.Listener {
        final IndexService indexService;

        private BitsetCacheListener(IndexService indexService) {
            this.indexService = indexService;
        }

        @Override
        public void onCache(ShardId shardId, Accountable accountable) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                long ramBytesUsed = accountable != null ? accountable.ramBytesUsed() : 0L;
                shard.shardBitsetFilterCache().onCached(ramBytesUsed);
            }
        }

        @Override
        public void onRemoval(ShardId shardId, Accountable accountable) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                long ramBytesUsed = accountable != null ? accountable.ramBytesUsed() : 0L;
                shard.shardBitsetFilterCache().onRemoval(ramBytesUsed);
            }
        }
    }

    private class StoreCloseListener
    implements Store.OnClose {
        private final ShardId shardId;
        private final boolean ownsShard;
        private final Closeable[] toClose;

        public StoreCloseListener(ShardId shardId, boolean ownsShard, Closeable ... toClose) {
            this.shardId = shardId;
            this.ownsShard = ownsShard;
            this.toClose = toClose;
        }

        @Override
        public void handle(ShardLock lock) {
            try {
                assert (lock.getShardId().equals(this.shardId)) : "shard id mismatch, expected: " + this.shardId + " but got: " + lock.getShardId();
                IndexService.this.onShardClose(lock, this.ownsShard);
            }
            finally {
                try {
                    IOUtils.close(this.toClose);
                }
                catch (IOException ex) {
                    IndexService.this.logger.debug("failed to close resource", (Throwable)ex);
                }
            }
        }
    }
}

