/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import java.net.SocketAddress;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.channel.Channel;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.handler.codec.http.HttpMethod;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpRequest
extends RestRequest {
    private final FullHttpRequest request;
    private final Channel channel;
    private final BytesReference content;

    Netty4HttpRequest(FullHttpRequest request, Channel channel) {
        super(request.uri());
        this.request = request;
        this.channel = channel;
        this.content = request.content().isReadable() ? Netty4Utils.toBytesReference(request.content()) : BytesArray.EMPTY;
    }

    public FullHttpRequest request() {
        return this.request;
    }

    @Override
    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.method();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        return RestRequest.Method.GET;
    }

    @Override
    public String uri() {
        return this.request.uri();
    }

    @Override
    public boolean hasContent() {
        return this.content.length() > 0;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.localAddress();
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public String header(String name) {
        return this.request.headers().get(name);
    }

    @Override
    public Iterable<Map.Entry<String, String>> headers() {
        return this.request.headers().entries();
    }
}

