/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TwoPhaseIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;

final class MinScoreScorer
extends Scorer {
    private final Scorer in;
    private final float minScore;

    MinScoreScorer(Weight weight, Scorer scorer, float minScore) {
        super(weight);
        if (!(scorer instanceof ScoreCachingWrappingScorer)) {
            scorer = new ScoreCachingWrappingScorer(scorer);
        }
        this.in = scorer;
        this.minScore = minScore;
    }

    public Scorer getScorer() {
        return this.in;
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public float score() throws IOException {
        return this.in.score();
    }

    @Override
    public int freq() throws IOException {
        return this.in.freq();
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator inTwoPhase = this.in.twoPhaseIterator();
        DocIdSetIterator approximation = inTwoPhase == null ? this.in.iterator() : inTwoPhase.approximation();
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                if (inTwoPhase != null && !inTwoPhase.matches()) {
                    return false;
                }
                return MinScoreScorer.this.in.score() >= MinScoreScorer.this.minScore;
            }

            @Override
            public float matchCost() {
                return 1000.0f + (inTwoPhase == null ? 0.0f : inTwoPhase.matchCost());
            }
        };
    }
}

