/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SimpleCollector;

public class MinimumScoreCollector
extends SimpleCollector {
    private final Collector collector;
    private final float minimumScore;
    private Scorer scorer;
    private LeafCollector leafCollector;

    public MinimumScoreCollector(Collector collector, float minimumScore) {
        this.collector = collector;
        this.minimumScore = minimumScore;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (!(scorer instanceof ScoreCachingWrappingScorer)) {
            scorer = new ScoreCachingWrappingScorer(scorer);
        }
        this.scorer = scorer;
        this.leafCollector.setScorer(scorer);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.scorer.score() >= this.minimumScore) {
            this.leafCollector.collect(doc);
        }
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.leafCollector = this.collector.getLeafCollector(context);
    }

    @Override
    public boolean needsScores() {
        return true;
    }
}

