/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.IntroSorter;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.MoveDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.NodeRebalanceResult;
import org.elasticsearch.cluster.routing.allocation.RebalanceDecision;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.PriorityComparator;

public class BalancedShardsAllocator
extends AbstractComponent
implements ShardsAllocator {
    public static final Setting<Float> INDEX_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.index", 0.55f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> SHARD_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.shard", 0.45f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> THRESHOLD_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.threshold", 1.0f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile WeightFunction weightFunction;
    private volatile float threshold;

    public BalancedShardsAllocator(Settings settings) {
        this(settings, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    @Inject
    public BalancedShardsAllocator(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.setWeightFunction(INDEX_BALANCE_FACTOR_SETTING.get(settings).floatValue(), SHARD_BALANCE_FACTOR_SETTING.get(settings).floatValue());
        this.setThreshold(THRESHOLD_SETTING.get(settings).floatValue());
        clusterSettings.addSettingsUpdateConsumer(INDEX_BALANCE_FACTOR_SETTING, SHARD_BALANCE_FACTOR_SETTING, this::setWeightFunction);
        clusterSettings.addSettingsUpdateConsumer(THRESHOLD_SETTING, this::setThreshold);
    }

    private void setWeightFunction(float indexBalance, float shardBalanceFactor) {
        this.weightFunction = new WeightFunction(indexBalance, shardBalanceFactor);
    }

    private void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    @Override
    public Map<DiscoveryNode, Float> weighShard(RoutingAllocation allocation, ShardRouting shard) {
        Balancer balancer = new Balancer(this.logger, allocation, this.weightFunction, this.threshold);
        return balancer.weighShard(shard);
    }

    @Override
    public void allocate(RoutingAllocation allocation) {
        if (allocation.routingNodes().size() == 0) {
            return;
        }
        Balancer balancer = new Balancer(this.logger, allocation, this.weightFunction, this.threshold);
        balancer.allocateUnassigned();
        balancer.moveShards();
        balancer.balance();
    }

    public RebalanceDecision decideRebalance(ShardRouting shard, RoutingAllocation allocation) {
        assert (allocation.debugDecision()) : "debugDecision should be set in explain mode";
        return new Balancer(this.logger, allocation, this.weightFunction, this.threshold).decideRebalance(shard);
    }

    public float getThreshold() {
        return this.threshold;
    }

    public float getIndexBalance() {
        return this.weightFunction.indexBalance;
    }

    public float getShardBalance() {
        return this.weightFunction.shardBalance;
    }

    static final class NodeSorter
    extends IntroSorter {
        final ModelNode[] modelNodes;
        final float[] weights;
        private final WeightFunction function;
        private String index;
        private final Balancer balancer;
        private float pivotWeight;

        public NodeSorter(ModelNode[] modelNodes, WeightFunction function, Balancer balancer) {
            this.function = function;
            this.balancer = balancer;
            this.modelNodes = modelNodes;
            this.weights = new float[modelNodes.length];
        }

        public void reset(String index, int from, int to) {
            this.index = index;
            for (int i = from; i < to; ++i) {
                this.weights[i] = this.weight(this.modelNodes[i]);
            }
            this.sort(from, to);
        }

        public void reset(String index) {
            this.reset(index, 0, this.modelNodes.length);
        }

        public float weight(ModelNode node) {
            return this.function.weight(this.balancer, node, this.index);
        }

        @Override
        protected void swap(int i, int j) {
            ModelNode tmpNode = this.modelNodes[i];
            this.modelNodes[i] = this.modelNodes[j];
            this.modelNodes[j] = tmpNode;
            float tmpWeight = this.weights[i];
            this.weights[i] = this.weights[j];
            this.weights[j] = tmpWeight;
        }

        @Override
        protected int compare(int i, int j) {
            return Float.compare(this.weights[i], this.weights[j]);
        }

        @Override
        protected void setPivot(int i) {
            this.pivotWeight = this.weights[i];
        }

        @Override
        protected int comparePivot(int j) {
            return Float.compare(this.pivotWeight, this.weights[j]);
        }

        public float delta() {
            return this.weights[this.weights.length - 1] - this.weights[0];
        }
    }

    static final class ModelIndex
    implements Iterable<ShardRouting> {
        private final String id;
        private final Set<ShardRouting> shards = new HashSet<ShardRouting>(4);
        private int highestPrimary = -1;

        public ModelIndex(String id) {
            this.id = id;
        }

        public int highestPrimary() {
            if (this.highestPrimary == -1) {
                int maxId = -1;
                for (ShardRouting shard : this.shards) {
                    if (!shard.primary()) continue;
                    maxId = Math.max(maxId, shard.id());
                }
                this.highestPrimary = maxId;
                return this.highestPrimary;
            }
            return this.highestPrimary;
        }

        public String getIndexId() {
            return this.id;
        }

        public int numShards() {
            return this.shards.size();
        }

        @Override
        public Iterator<ShardRouting> iterator() {
            return this.shards.iterator();
        }

        public void removeShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (this.shards.contains(shard)) : "Shard not allocated on current node: " + shard;
            this.shards.remove(shard);
        }

        public void addShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (!this.shards.contains(shard)) : "Shard already allocated on current node: " + shard;
            this.shards.add(shard);
        }

        public boolean containsShard(ShardRouting shard) {
            return this.shards.contains(shard);
        }
    }

    static class ModelNode
    implements Iterable<ModelIndex> {
        private final Map<String, ModelIndex> indices = new HashMap<String, ModelIndex>();
        private int numShards = 0;
        private final RoutingNode routingNode;

        public ModelNode(RoutingNode routingNode) {
            this.routingNode = routingNode;
        }

        public ModelIndex getIndex(String indexId) {
            return this.indices.get(indexId);
        }

        public String getNodeId() {
            return this.routingNode.nodeId();
        }

        public RoutingNode getRoutingNode() {
            return this.routingNode;
        }

        public int numShards() {
            return this.numShards;
        }

        public int numShards(String idx) {
            ModelIndex index = this.indices.get(idx);
            return index == null ? 0 : index.numShards();
        }

        public int highestPrimary(String index) {
            ModelIndex idx = this.indices.get(index);
            if (idx != null) {
                return idx.highestPrimary();
            }
            return -1;
        }

        public void addShard(ShardRouting shard) {
            ModelIndex index = this.indices.get(shard.getIndexName());
            if (index == null) {
                index = new ModelIndex(shard.getIndexName());
                this.indices.put(index.getIndexId(), index);
            }
            index.addShard(shard);
            ++this.numShards;
        }

        public void removeShard(ShardRouting shard) {
            ModelIndex index = this.indices.get(shard.getIndexName());
            if (index != null) {
                index.removeShard(shard);
                if (index.numShards() == 0) {
                    this.indices.remove(shard.getIndexName());
                }
            }
            --this.numShards;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node(").append(this.routingNode.nodeId()).append(")");
            return sb.toString();
        }

        @Override
        public Iterator<ModelIndex> iterator() {
            return this.indices.values().iterator();
        }

        public boolean containsShard(ShardRouting shard) {
            ModelIndex index = this.getIndex(shard.getIndexName());
            return index == null ? false : index.containsShard(shard);
        }
    }

    public static class Balancer {
        private final Logger logger;
        private final Map<String, ModelNode> nodes;
        private final RoutingAllocation allocation;
        private final RoutingNodes routingNodes;
        private final WeightFunction weight;
        private final float threshold;
        private final MetaData metaData;
        private final float avgShardsPerNode;
        private final NodeSorter sorter;

        public Balancer(Logger logger, RoutingAllocation allocation, WeightFunction weight, float threshold) {
            this.logger = logger;
            this.allocation = allocation;
            this.weight = weight;
            this.threshold = threshold;
            this.routingNodes = allocation.routingNodes();
            this.metaData = allocation.metaData();
            this.avgShardsPerNode = (float)this.metaData.getTotalNumberOfShards() / (float)this.routingNodes.size();
            this.nodes = Collections.unmodifiableMap(this.buildModelFromAssigned());
            this.sorter = this.newNodeSorter();
        }

        private ModelNode[] nodesArray() {
            return this.nodes.values().toArray(new ModelNode[this.nodes.size()]);
        }

        public float avgShardsPerNode(String index) {
            return (float)this.metaData.index(index).getTotalNumberOfShards() / (float)this.nodes.size();
        }

        public float avgShardsPerNode() {
            return this.avgShardsPerNode;
        }

        private NodeSorter newNodeSorter() {
            return new NodeSorter(this.nodesArray(), this.weight, this);
        }

        private static float absDelta(float lower, float higher) {
            assert (higher >= lower) : higher + " lt " + lower + " but was expected to be gte";
            return Math.abs(higher - lower);
        }

        private static boolean lessThan(float delta, float threshold) {
            return delta <= threshold + 0.001f;
        }

        private void balance() {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Start balancing cluster");
            }
            if (this.allocation.hasPendingAsyncFetch()) {
                this.logger.debug("skipping rebalance due to in-flight shard/store fetches");
                return;
            }
            if (this.allocation.deciders().canRebalance(this.allocation).type() != Decision.Type.YES) {
                this.logger.trace("skipping rebalance as it is disabled");
                return;
            }
            if (this.nodes.size() < 2) {
                this.logger.trace("skipping rebalance as single node only");
                return;
            }
            this.balanceByWeights();
        }

        private RebalanceDecision decideRebalance(ShardRouting shard) {
            if (!shard.started()) {
                return RebalanceDecision.NOT_TAKEN;
            }
            Decision canRebalance = this.allocation.deciders().canRebalance(shard, this.allocation);
            if (this.allocation.hasPendingAsyncFetch()) {
                return new RebalanceDecision(canRebalance, Decision.Type.NO, "cannot rebalance due to in-flight shard store fetches, otherwise allocation may prematurely rebalance a shard to a node that is soon to receive another shard assignment upon completion of the shard store fetch, rendering the cluster imbalanced again");
            }
            this.sorter.reset(shard.getIndexName());
            ModelNode[] modelNodes = this.sorter.modelNodes;
            String currentNodeId = shard.currentNodeId();
            ModelNode currentNode = null;
            for (ModelNode node : modelNodes) {
                if (!node.getNodeId().equals(currentNodeId)) continue;
                currentNode = node;
                break;
            }
            assert (currentNode != null) : "currently assigned node could not be found";
            float currentWeight = this.sorter.weight(currentNode);
            AllocationDeciders deciders = this.allocation.deciders();
            String idxName = shard.getIndexName();
            HashMap<String, NodeRebalanceResult> nodeDecisions = new HashMap<String, NodeRebalanceResult>(modelNodes.length - 1);
            Decision.Type rebalanceDecisionType = Decision.Type.NO;
            String assignedNodeId = null;
            for (ModelNode node : modelNodes) {
                if (node == currentNode) continue;
                Decision canAllocate = deciders.canAllocate(shard, node.getRoutingNode(), this.allocation);
                float nodeWeight = this.sorter.weight(node);
                boolean betterWeightThanCurrent = nodeWeight <= currentWeight;
                boolean rebalanceConditionsMet = false;
                boolean deltaAboveThreshold = false;
                float weightWithShardAdded = Float.POSITIVE_INFINITY;
                if (betterWeightThanCurrent) {
                    float currentDelta = Balancer.absDelta(nodeWeight, currentWeight);
                    deltaAboveThreshold = !Balancer.lessThan(currentDelta, this.threshold);
                    weightWithShardAdded = this.weight.weightShardAdded(this, node, idxName);
                    float proposedDelta = weightWithShardAdded - this.weight.weightShardRemoved(this, currentNode, idxName);
                    boolean bl = rebalanceConditionsMet = deltaAboveThreshold && proposedDelta < currentDelta;
                    if (rebalanceConditionsMet && canAllocate.type().higherThan(rebalanceDecisionType)) {
                        rebalanceDecisionType = canAllocate.type();
                        assignedNodeId = node.getNodeId();
                    }
                }
                nodeDecisions.put(node.getNodeId(), new NodeRebalanceResult(rebalanceConditionsMet ? canAllocate.type() : Decision.Type.NO, canAllocate, betterWeightThanCurrent, deltaAboveThreshold, nodeWeight, weightWithShardAdded));
            }
            if (canRebalance.type() != Decision.Type.YES) {
                return new RebalanceDecision(canRebalance, canRebalance.type(), "rebalancing is not allowed", null, nodeDecisions, currentWeight);
            }
            return RebalanceDecision.decision(canRebalance, rebalanceDecisionType, assignedNodeId, nodeDecisions, currentWeight, this.threshold);
        }

        public Map<DiscoveryNode, Float> weighShard(ShardRouting shard) {
            int i;
            ModelNode[] modelNodes = this.sorter.modelNodes;
            float[] weights = this.sorter.weights;
            this.buildWeightOrderedIndices();
            HashMap<DiscoveryNode, Float> nodes = new HashMap<DiscoveryNode, Float>(modelNodes.length);
            float currentNodeWeight = 0.0f;
            for (i = 0; i < modelNodes.length; ++i) {
                if (!modelNodes[i].getNodeId().equals(shard.currentNodeId())) continue;
                currentNodeWeight = weights[i];
                break;
            }
            for (i = 0; i < modelNodes.length; ++i) {
                float delta = currentNodeWeight - weights[i];
                nodes.put(modelNodes[i].getRoutingNode().node(), Float.valueOf(delta));
            }
            return nodes;
        }

        private void balanceByWeights() {
            AllocationDeciders deciders = this.allocation.deciders();
            ModelNode[] modelNodes = this.sorter.modelNodes;
            float[] weights = this.sorter.weights;
            block0: for (String index : this.buildWeightOrderedIndices()) {
                IndexMetaData indexMetaData = this.metaData.index(index);
                int relevantNodes = 0;
                for (int i = 0; i < modelNodes.length; ++i) {
                    ModelNode modelNode = modelNodes[i];
                    if (modelNode.getIndex(index) == null && deciders.canAllocate(indexMetaData, modelNode.getRoutingNode(), this.allocation).type() == Decision.Type.NO) continue;
                    modelNodes[i] = modelNodes[relevantNodes];
                    modelNodes[relevantNodes] = modelNode;
                    ++relevantNodes;
                }
                if (relevantNodes < 2) continue;
                this.sorter.reset(index, 0, relevantNodes);
                int lowIdx = 0;
                int highIdx = relevantNodes - 1;
                while (true) {
                    ModelNode minNode = modelNodes[lowIdx];
                    ModelNode maxNode = modelNodes[highIdx];
                    if (maxNode.numShards(index) > 0) {
                        float delta = Balancer.absDelta(weights[lowIdx], weights[highIdx]);
                        if (Balancer.lessThan(delta, this.threshold)) {
                            if (lowIdx <= 0 || highIdx - 1 <= 0 || !(Balancer.absDelta(weights[0], weights[highIdx - 1]) > this.threshold)) {
                                if (!this.logger.isTraceEnabled()) continue block0;
                                this.logger.trace("Stop balancing index [{}]  min_node [{}] weight: [{}]  max_node [{}] weight: [{}]  delta: [{}]", (Object)index, (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                                continue block0;
                            }
                        } else {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Balancing from node [{}] weight: [{}] to node [{}] weight: [{}]  delta: [{}]", (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                            }
                            if (this.tryRelocateShard(minNode, maxNode, index, delta)) {
                                weights[lowIdx] = this.sorter.weight(modelNodes[lowIdx]);
                                weights[highIdx] = this.sorter.weight(modelNodes[highIdx]);
                                this.sorter.sort(0, relevantNodes);
                                lowIdx = 0;
                                highIdx = relevantNodes - 1;
                                continue;
                            }
                        }
                    }
                    if (lowIdx < highIdx - 1) {
                        ++lowIdx;
                        continue;
                    }
                    if (lowIdx <= 0) continue block0;
                    lowIdx = 0;
                    --highIdx;
                }
            }
        }

        private String[] buildWeightOrderedIndices() {
            final String[] indices = this.allocation.routingTable().indicesRouting().keys().toArray(String.class);
            final float[] deltas = new float[indices.length];
            for (int i = 0; i < deltas.length; ++i) {
                this.sorter.reset(indices[i]);
                deltas[i] = this.sorter.delta();
            }
            new IntroSorter(){
                float pivotWeight;

                @Override
                protected void swap(int i, int j) {
                    String tmpIdx = indices[i];
                    indices[i] = indices[j];
                    indices[j] = tmpIdx;
                    float tmpDelta = deltas[i];
                    deltas[i] = deltas[j];
                    deltas[j] = tmpDelta;
                }

                @Override
                protected int compare(int i, int j) {
                    return Float.compare(deltas[j], deltas[i]);
                }

                @Override
                protected void setPivot(int i) {
                    this.pivotWeight = deltas[i];
                }

                @Override
                protected int comparePivot(int j) {
                    return Float.compare(deltas[j], this.pivotWeight);
                }
            }.sort(0, deltas.length);
            return indices;
        }

        public void moveShards() {
            Iterator<ShardRouting> it = this.allocation.routingNodes().nodeInterleavedShardIterator();
            while (it.hasNext()) {
                ShardRouting shardRouting = it.next();
                MoveDecision moveDecision = this.makeMoveDecision(shardRouting);
                if (moveDecision.move()) {
                    ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
                    ModelNode targetNode = this.nodes.get(moveDecision.getAssignedNodeId());
                    sourceNode.removeShard(shardRouting);
                    Tuple<ShardRouting, ShardRouting> relocatingShards = this.routingNodes.relocateShard(shardRouting, targetNode.getNodeId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L), this.allocation.changes());
                    targetNode.addShard(relocatingShards.v2());
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace("Moved shard [{}] to node [{}]", (Object)shardRouting, (Object)targetNode.getRoutingNode());
                    continue;
                }
                if (!moveDecision.cannotRemain()) continue;
                this.logger.trace("[{}][{}] can't move", (Object)shardRouting.index(), (Object)shardRouting.id());
            }
        }

        public MoveDecision makeMoveDecision(ShardRouting shardRouting) {
            if (!shardRouting.started()) {
                return MoveDecision.NOT_TAKEN;
            }
            boolean explain = this.allocation.debugDecision();
            ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
            assert (sourceNode != null && sourceNode.containsShard(shardRouting));
            RoutingNode routingNode = sourceNode.getRoutingNode();
            Decision canRemain = this.allocation.deciders().canRemain(shardRouting, routingNode, this.allocation);
            if (canRemain.type() != Decision.Type.NO) {
                return MoveDecision.stay(canRemain, explain);
            }
            this.sorter.reset(shardRouting.getIndexName());
            Decision.Type bestDecision = Decision.Type.NO;
            RoutingNode targetNode = null;
            HashMap<String, NodeAllocationResult> nodeExplanationMap = explain ? new HashMap<String, NodeAllocationResult>() : null;
            for (ModelNode currentNode : this.sorter.modelNodes) {
                if (currentNode == sourceNode) continue;
                RoutingNode target = currentNode.getRoutingNode();
                Decision allocationDecision = this.allocation.deciders().canAllocate(shardRouting, target, this.allocation);
                if (explain) {
                    nodeExplanationMap.put(currentNode.getNodeId(), new NodeAllocationResult(allocationDecision, this.sorter.weight(currentNode)));
                }
                if (!allocationDecision.type().higherThan(bestDecision) || (bestDecision = allocationDecision.type()) != Decision.Type.YES) continue;
                targetNode = target;
                if (!explain) break;
            }
            return MoveDecision.decision(canRemain, bestDecision, explain, shardRouting.currentNodeId(), targetNode != null ? targetNode.nodeId() : null, nodeExplanationMap);
        }

        private Map<String, ModelNode> buildModelFromAssigned() {
            HashMap<String, ModelNode> nodes = new HashMap<String, ModelNode>();
            for (RoutingNode rn : this.routingNodes) {
                ModelNode node = new ModelNode(rn);
                nodes.put(rn.nodeId(), node);
                for (ShardRouting shard : rn) {
                    assert (rn.nodeId().equals(shard.currentNodeId()));
                    if (shard.state() == ShardRoutingState.RELOCATING) continue;
                    node.addShard(shard);
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace("Assigned shard [{}] to node [{}]", (Object)shard, (Object)node.getNodeId());
                }
            }
            return nodes;
        }

        private void allocateUnassigned() {
            RoutingNodes.UnassignedShards unassigned = this.routingNodes.unassigned();
            assert (!this.nodes.isEmpty());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Start allocating unassigned shards");
            }
            if (unassigned.isEmpty()) {
                return;
            }
            AllocationDeciders deciders = this.allocation.deciders();
            PriorityComparator secondaryComparator = PriorityComparator.getAllocationComparator(this.allocation);
            Comparator comparator = (o1, o2) -> {
                if (o1.primary() ^ o2.primary()) {
                    return o1.primary() ? -1 : (o2.primary() ? 1 : 0);
                }
                int indexCmp = o1.getIndexName().compareTo(o2.getIndexName());
                if (indexCmp == 0) {
                    return o1.getId() - o2.getId();
                }
                int secondary = secondaryComparator.compare((ShardRouting)o1, (ShardRouting)o2);
                return secondary == 0 ? indexCmp : secondary;
            };
            ShardRouting[] primary = unassigned.drain();
            ShardRouting[] secondary = new ShardRouting[primary.length];
            int secondaryLength = 0;
            int primaryLength = primary.length;
            ArrayUtil.timSort(primary, comparator);
            Set<ModelNode> throttledNodes = Collections.newSetFromMap(new IdentityHashMap());
            do {
                for (int i = 0; i < primaryLength; ++i) {
                    long shardSize;
                    ModelNode minNode;
                    ShardRouting shard = primary[i];
                    AllocateUnassignedDecision allocationDecision = this.decideAllocateUnassigned(shard, throttledNodes);
                    Decision.Type decisionType = allocationDecision.getFinalDecisionType();
                    String assignedNodeId = allocationDecision.getAssignedNodeId();
                    ModelNode modelNode = minNode = assignedNodeId != null ? this.nodes.get(assignedNodeId) : null;
                    if (decisionType == Decision.Type.YES) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Assigned shard [{}] to [{}]", (Object)shard, (Object)minNode.getNodeId());
                        }
                        shardSize = DiskThresholdDecider.getExpectedShardSize(shard, this.allocation, -1L);
                        shard = this.routingNodes.initializeShard(shard, minNode.getNodeId(), null, shardSize, this.allocation.changes());
                        minNode.addShard(shard);
                        if (shard.primary()) continue;
                        while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                            secondary[secondaryLength++] = primary[++i];
                        }
                        continue;
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("No eligible node found to assign shard [{}] decision [{}]", (Object)shard, (Object)decisionType);
                    }
                    if (minNode != null) {
                        assert (decisionType == Decision.Type.THROTTLE);
                        shardSize = DiskThresholdDecider.getExpectedShardSize(shard, this.allocation, -1L);
                        minNode.addShard(shard.initialize(minNode.getNodeId(), null, shardSize));
                        RoutingNode node = minNode.getRoutingNode();
                        Decision.Type nodeLevelDecision = deciders.canAllocate(node, this.allocation).type();
                        if (nodeLevelDecision != Decision.Type.YES) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Can not allocate on node [{}] remove from round decision [{}]", (Object)node, (Object)decisionType);
                            }
                            assert (nodeLevelDecision == Decision.Type.NO);
                            throttledNodes.add(minNode);
                        }
                    } else {
                        assert (decisionType == Decision.Type.NO);
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("No Node found to assign shard [{}]", (Object)shard);
                        }
                    }
                    UnassignedInfo.AllocationStatus allocationStatus = UnassignedInfo.AllocationStatus.fromDecision(decisionType);
                    unassigned.ignoreShard(shard, allocationStatus, this.allocation.changes());
                    if (shard.primary()) continue;
                    while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                        unassigned.ignoreShard(primary[++i], allocationStatus, this.allocation.changes());
                    }
                }
                primaryLength = secondaryLength;
                ShardRouting[] tmp = primary;
                primary = secondary;
                secondary = tmp;
                secondaryLength = 0;
            } while (primaryLength > 0);
        }

        private AllocateUnassignedDecision decideAllocateUnassigned(ShardRouting shard, Set<ModelNode> throttledNodes) {
            if (shard.assignedToNode()) {
                return AllocateUnassignedDecision.NOT_TAKEN;
            }
            Decision shardLevelDecision = this.allocation.deciders().canAllocate(shard, this.allocation);
            if (shardLevelDecision.type() == Decision.Type.NO) {
                return AllocateUnassignedDecision.no(shardLevelDecision, this.explain("cannot allocate shard in its current state"));
            }
            float minWeight = Float.POSITIVE_INFINITY;
            ModelNode minNode = null;
            Decision decision = null;
            boolean explain = this.allocation.debugDecision();
            if (throttledNodes.size() >= this.nodes.size() && !explain) {
                return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.DECIDERS_NO, null);
            }
            HashMap<String, NodeAllocationResult> nodeExplanationMap = explain ? new HashMap<String, NodeAllocationResult>() : null;
            for (ModelNode node : this.nodes.values()) {
                boolean updateMinNode;
                float currentWeight;
                if ((throttledNodes.contains(node) || node.containsShard(shard)) && !explain || (currentWeight = this.weight.weightShardAdded(this, node, shard.getIndexName())) > minWeight && !explain) continue;
                Decision currentDecision = this.allocation.deciders().canAllocate(shard, node.getRoutingNode(), this.allocation);
                if (explain) {
                    nodeExplanationMap.put(node.getNodeId(), new NodeAllocationResult(currentDecision, currentWeight));
                }
                if (currentDecision.type() != Decision.Type.YES && currentDecision.type() != Decision.Type.THROTTLE) continue;
                if (currentWeight == minWeight) {
                    if (currentDecision.type() == decision.type()) {
                        int repId = shard.id();
                        int nodeHigh = node.highestPrimary(shard.index().getName());
                        int minNodeHigh = minNode.highestPrimary(shard.getIndexName());
                        updateMinNode = (nodeHigh > repId && minNodeHigh > repId || nodeHigh < repId && minNodeHigh < repId) && nodeHigh < minNodeHigh || nodeHigh > minNodeHigh && nodeHigh > repId && minNodeHigh < repId;
                    } else {
                        updateMinNode = currentDecision.type() == Decision.Type.YES;
                    }
                } else {
                    updateMinNode = true;
                }
                if (!updateMinNode) continue;
                minNode = node;
                minWeight = currentWeight;
                decision = currentDecision;
            }
            if (decision == null) {
                decision = Decision.NO;
            }
            return AllocateUnassignedDecision.fromDecision(decision, minNode != null ? minNode.getNodeId() : null, explain, nodeExplanationMap);
        }

        private String explain(String explanation) {
            if (this.allocation.debugDecision()) {
                return explanation;
            }
            return null;
        }

        private boolean tryRelocateShard(ModelNode minNode, ModelNode maxNode, String idx, float minCost) {
            ModelIndex index = maxNode.getIndex(idx);
            Decision decision = null;
            if (index != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Try relocating shard for index index [{}] from node [{}] to node [{}]", (Object)idx, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                }
                ShardRouting candidate = null;
                AllocationDeciders deciders = this.allocation.deciders();
                for (ShardRouting shard : index) {
                    float delta;
                    if (!shard.started()) continue;
                    Decision allocationDecision = deciders.canAllocate(shard, minNode.getRoutingNode(), this.allocation);
                    Decision rebalanceDecision = deciders.canRebalance(shard, this.allocation);
                    if (allocationDecision.type() != Decision.Type.YES && allocationDecision.type() != Decision.Type.THROTTLE || rebalanceDecision.type() != Decision.Type.YES && rebalanceDecision.type() != Decision.Type.THROTTLE || !maxNode.containsShard(shard) || !((delta = this.weight.weightShardAdded(this, minNode, idx) - this.weight.weightShardRemoved(this, maxNode, idx)) < minCost) && (candidate == null || delta != minCost || candidate.id() <= shard.id())) continue;
                    minCost = delta;
                    candidate = shard;
                    decision = new Decision.Multi().add(allocationDecision).add(rebalanceDecision);
                }
                if (candidate != null) {
                    maxNode.removeShard(candidate);
                    long shardSize = this.allocation.clusterInfo().getShardSize(candidate, -1L);
                    if (decision.type() == Decision.Type.YES) {
                        this.logger.debug("Relocate shard [{}] from node [{}] to node [{}]", (Object)candidate, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                        minNode.addShard(this.routingNodes.relocateShard(candidate, minNode.getNodeId(), shardSize, this.allocation.changes()).v1());
                        return true;
                    }
                    assert (decision.type() == Decision.Type.THROTTLE);
                    minNode.addShard(candidate.relocate(minNode.getNodeId(), shardSize));
                }
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Couldn't find shard to relocate from node [{}] to node [{}] allocation decision [{}]", (Object)maxNode.getNodeId(), (Object)minNode.getNodeId(), (Object)(decision == null ? "NO" : decision.type().name()));
            }
            return false;
        }
    }

    public static class WeightFunction {
        private final float indexBalance;
        private final float shardBalance;
        private final float theta0;
        private final float theta1;

        public WeightFunction(float indexBalance, float shardBalance) {
            float sum = indexBalance + shardBalance;
            if (sum <= 0.0f) {
                throw new IllegalArgumentException("Balance factors must sum to a value > 0 but was: " + sum);
            }
            this.theta0 = shardBalance / sum;
            this.theta1 = indexBalance / sum;
            this.indexBalance = indexBalance;
            this.shardBalance = shardBalance;
        }

        public float weight(Balancer balancer, ModelNode node, String index) {
            return this.weight(balancer, node, index, 0);
        }

        public float weightShardAdded(Balancer balancer, ModelNode node, String index) {
            return this.weight(balancer, node, index, 1);
        }

        public float weightShardRemoved(Balancer balancer, ModelNode node, String index) {
            return this.weight(balancer, node, index, -1);
        }

        private float weight(Balancer balancer, ModelNode node, String index, int numAdditionalShards) {
            float weightShard = (float)(node.numShards() + numAdditionalShards) - balancer.avgShardsPerNode();
            float weightIndex = (float)(node.numShards(index) + numAdditionalShards) - balancer.avgShardsPerNode(index);
            return this.theta0 * weightShard + this.theta1 * weightIndex;
        }
    }
}

