/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RelocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Nullable;

public final class MoveDecision
extends RelocationDecision {
    public static final MoveDecision NOT_TAKEN = new MoveDecision(null, null, null, null, null);
    private static final MoveDecision CACHED_STAY_DECISION = new MoveDecision(Decision.YES, Decision.Type.NO, null, null, null);
    private static final MoveDecision CACHED_CANNOT_MOVE_DECISION = new MoveDecision(Decision.NO, Decision.Type.NO, null, null, null);
    @Nullable
    private final Decision canRemainDecision;
    @Nullable
    private final Map<String, NodeAllocationResult> nodeDecisions;

    private MoveDecision(Decision canRemainDecision, Decision.Type finalDecision, String finalExplanation, String assignedNodeId, Map<String, NodeAllocationResult> nodeDecisions) {
        super(finalDecision, finalExplanation, assignedNodeId);
        this.canRemainDecision = canRemainDecision;
        this.nodeDecisions = nodeDecisions != null ? Collections.unmodifiableMap(nodeDecisions) : null;
    }

    public static MoveDecision stay(Decision canRemainDecision, boolean explain) {
        assert (canRemainDecision.type() != Decision.Type.NO);
        if (explain) {
            String explanation = explain ? "shard is allowed to remain on its current node, so no reason to move" : null;
            return new MoveDecision(Objects.requireNonNull(canRemainDecision), Decision.Type.NO, explanation, null, null);
        }
        return CACHED_STAY_DECISION;
    }

    public static MoveDecision decision(Decision canRemainDecision, Decision.Type finalDecision, boolean explain, String currentNodeId, String assignedNodeId, Map<String, NodeAllocationResult> nodeDecisions) {
        assert (canRemainDecision != null);
        assert (canRemainDecision.type() != Decision.Type.YES) : "create decision with MoveDecision#stay instead";
        String finalExplanation = null;
        if (explain) {
            assert (currentNodeId != null);
            if (finalDecision == Decision.Type.YES) {
                assert (assignedNodeId != null);
                finalExplanation = "shard cannot remain on node [" + currentNodeId + "], moving to node [" + assignedNodeId + "]";
            } else {
                finalExplanation = finalDecision == Decision.Type.THROTTLE ? "shard cannot remain on node [" + currentNodeId + "], throttled on moving to another node" : "shard cannot remain on node [" + currentNodeId + "], but cannot be assigned to any other node";
            }
        }
        if (finalExplanation == null && finalDecision == Decision.Type.NO) {
            return CACHED_CANNOT_MOVE_DECISION;
        }
        assert (assignedNodeId == null == (finalDecision != Decision.Type.YES));
        return new MoveDecision(canRemainDecision, finalDecision, finalExplanation, assignedNodeId, nodeDecisions);
    }

    public boolean move() {
        return this.cannotRemain() && this.getFinalDecisionType() == Decision.Type.YES;
    }

    public boolean cannotRemain() {
        return this.isDecisionTaken() && this.canRemainDecision.type() == Decision.Type.NO;
    }

    @Nullable
    public Map<String, NodeAllocationResult> getNodeDecisions() {
        return this.nodeDecisions;
    }
}

