/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.ScrollIdForNode;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class TransportClearScrollAction
extends HandledTransportAction<ClearScrollRequest, ClearScrollResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;

    @Inject
    public TransportClearScrollAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/scroll/clear", threadPool, transportService, actionFilters, indexNameExpressionResolver, ClearScrollRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = new SearchTransportService(settings, transportService);
    }

    @Override
    protected void doExecute(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener) {
        new Async(request, listener, this.clusterService.state()).run();
    }

    private class Async {
        final DiscoveryNodes nodes;
        final CountDown expectedOps;
        final List<ScrollIdForNode[]> contexts = new ArrayList<ScrollIdForNode[]>();
        final ActionListener<ClearScrollResponse> listener;
        final AtomicReference<Throwable> expHolder;
        final AtomicInteger numberOfFreedSearchContexts = new AtomicInteger(0);

        private Async(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener, ClusterState clusterState) {
            int expectedOps = 0;
            this.nodes = clusterState.nodes();
            if (request.getScrollIds().size() == 1 && "_all".equals(request.getScrollIds().get(0))) {
                expectedOps = this.nodes.getSize();
            } else {
                for (String parsedScrollId : request.getScrollIds()) {
                    ScrollIdForNode[] context = TransportSearchHelper.parseScrollId(parsedScrollId).getContext();
                    expectedOps += context.length;
                    this.contexts.add(context);
                }
            }
            this.listener = listener;
            this.expHolder = new AtomicReference();
            this.expectedOps = new CountDown(expectedOps);
        }

        public void run() {
            if (this.expectedOps.isCountedDown()) {
                this.listener.onResponse(new ClearScrollResponse(true, 0));
                return;
            }
            if (this.contexts.isEmpty()) {
                for (final DiscoveryNode node : this.nodes) {
                    TransportClearScrollAction.this.searchTransportService.sendClearAllScrollContexts(node, new ActionListener<TransportResponse>(){

                        @Override
                        public void onResponse(TransportResponse response) {
                            Async.this.onFreedContext(true);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            Async.this.onFailedFreedContext(e, node);
                        }
                    });
                }
            } else {
                for (ScrollIdForNode[] context : this.contexts) {
                    for (ScrollIdForNode target : context) {
                        final DiscoveryNode node = this.nodes.get(target.getNode());
                        if (node == null) {
                            this.onFreedContext(false);
                            continue;
                        }
                        TransportClearScrollAction.this.searchTransportService.sendFreeContext(node, target.getScrollId(), new ActionListener<SearchTransportService.SearchFreeContextResponse>(){

                            @Override
                            public void onResponse(SearchTransportService.SearchFreeContextResponse freed) {
                                Async.this.onFreedContext(freed.isFreed());
                            }

                            @Override
                            public void onFailure(Exception e) {
                                Async.this.onFailedFreedContext(e, node);
                            }
                        });
                    }
                }
            }
        }

        void onFreedContext(boolean freed) {
            if (freed) {
                this.numberOfFreedSearchContexts.incrementAndGet();
            }
            if (this.expectedOps.countDown()) {
                boolean succeeded = this.expHolder.get() == null;
                this.listener.onResponse(new ClearScrollResponse(succeeded, this.numberOfFreedSearchContexts.get()));
            }
        }

        void onFailedFreedContext(Throwable e, DiscoveryNode node) {
            TransportClearScrollAction.this.logger.warn(() -> new ParameterizedMessage("Clear SC failed on node[{}]", (Object)node), e);
            if (this.expectedOps.countDown()) {
                this.listener.onResponse(new ClearScrollResponse(false, this.numberOfFreedSearchContexts.get()));
            } else {
                this.expHolder.set(e);
            }
        }
    }
}

