/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ingest.SimulateProcessorResult;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class TrackingResultProcessor
implements Processor {
    private final Processor actualProcessor;
    private final List<SimulateProcessorResult> processorResultList;
    private final boolean ignoreFailure;

    public TrackingResultProcessor(boolean ignoreFailure, Processor actualProcessor, List<SimulateProcessorResult> processorResultList) {
        this.ignoreFailure = ignoreFailure;
        this.processorResultList = processorResultList;
        this.actualProcessor = actualProcessor;
    }

    @Override
    public void execute(IngestDocument ingestDocument) throws Exception {
        try {
            this.actualProcessor.execute(ingestDocument);
            this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getTag(), new IngestDocument(ingestDocument)));
        }
        catch (Exception e) {
            if (this.ignoreFailure) {
                this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getTag(), new IngestDocument(ingestDocument), e));
            } else {
                this.processorResultList.add(new SimulateProcessorResult(this.actualProcessor.getTag(), e));
            }
            throw e;
        }
    }

    @Override
    public String getType() {
        return this.actualProcessor.getType();
    }

    @Override
    public String getTag() {
        return this.actualProcessor.getTag();
    }

    public static CompoundProcessor decorate(CompoundProcessor compoundProcessor, List<SimulateProcessorResult> processorResultList) {
        ArrayList<Processor> processors = new ArrayList<Processor>(compoundProcessor.getProcessors().size());
        for (Processor processor : compoundProcessor.getProcessors()) {
            if (processor instanceof CompoundProcessor) {
                processors.add(TrackingResultProcessor.decorate((CompoundProcessor)processor, processorResultList));
                continue;
            }
            processors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, processorResultList));
        }
        ArrayList<Processor> onFailureProcessors = new ArrayList<Processor>(compoundProcessor.getProcessors().size());
        for (Processor processor : compoundProcessor.getOnFailureProcessors()) {
            if (processor instanceof CompoundProcessor) {
                onFailureProcessors.add(TrackingResultProcessor.decorate((CompoundProcessor)processor, processorResultList));
                continue;
            }
            onFailureProcessors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, processorResultList));
        }
        return new CompoundProcessor(compoundProcessor.isIgnoreFailure(), processors, onFailureProcessors);
    }
}

