/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class IndexResponse
extends DocWriteResponse {
    public IndexResponse() {
    }

    public IndexResponse(ShardId shardId, String type, String id, long version, boolean created) {
        super(shardId, type, id, version, created ? DocWriteResponse.Result.CREATED : DocWriteResponse.Result.UPDATED);
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IndexResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(Strings.toString(this.getShardInfo(), true));
        return builder.append("]").toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.toXContent(builder, params);
        builder.field("created", this.result == DocWriteResponse.Result.CREATED);
        return builder;
    }
}

