/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParseFieldMatcherSupplier;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class ClusterAllocationExplainRequest
extends MasterNodeRequest<ClusterAllocationExplainRequest> {
    private static ObjectParser<ClusterAllocationExplainRequest, ParseFieldMatcherSupplier> PARSER = new ObjectParser("cluster/allocation/explain");
    private String index;
    private Integer shard;
    private Boolean primary;
    private boolean includeYesDecisions = false;
    private boolean includeDiskInfo = false;

    public ClusterAllocationExplainRequest() {
        this.index = null;
        this.shard = null;
        this.primary = null;
    }

    public ClusterAllocationExplainRequest(String index, int shard, boolean primary) {
        this.index = index;
        this.shard = shard;
        this.primary = primary;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!this.useAnyUnassignedShard()) {
            if (this.index == null) {
                validationException = ValidateActions.addValidationError("index must be specified", validationException);
            }
            if (this.shard == null) {
                validationException = ValidateActions.addValidationError("shard must be specified", validationException);
            }
            if (this.primary == null) {
                validationException = ValidateActions.addValidationError("primary must be specified", validationException);
            }
        }
        return validationException;
    }

    public boolean useAnyUnassignedShard() {
        return this.index == null && this.shard == null && this.primary == null;
    }

    public ClusterAllocationExplainRequest setIndex(String index) {
        this.index = index;
        return this;
    }

    @Nullable
    public String getIndex() {
        return this.index;
    }

    public ClusterAllocationExplainRequest setShard(Integer shard) {
        this.shard = shard;
        return this;
    }

    @Nullable
    public Integer getShard() {
        return this.shard;
    }

    public ClusterAllocationExplainRequest setPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Nullable
    public Boolean isPrimary() {
        return this.primary;
    }

    public void includeYesDecisions(boolean includeYesDecisions) {
        this.includeYesDecisions = includeYesDecisions;
    }

    public boolean includeYesDecisions() {
        return this.includeYesDecisions;
    }

    public void includeDiskInfo(boolean includeDiskInfo) {
        this.includeDiskInfo = includeDiskInfo;
    }

    public boolean includeDiskInfo() {
        return this.includeDiskInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClusterAllocationExplainRequest[");
        if (this.useAnyUnassignedShard()) {
            sb.append("useAnyUnassignedShard=true");
        } else {
            sb.append("index=").append(this.index);
            sb.append(",shard=").append(this.shard);
            sb.append(",primary?=").append(this.primary);
        }
        sb.append(",includeYesDecisions?=").append(this.includeYesDecisions);
        return sb.toString();
    }

    public static ClusterAllocationExplainRequest parse(XContentParser parser) throws IOException {
        ClusterAllocationExplainRequest req = PARSER.parse(parser, new ClusterAllocationExplainRequest(), () -> ParseFieldMatcher.STRICT);
        ActionRequestValidationException e = req.validate();
        if (e != null) {
            throw new ElasticsearchParseException("'index', 'shard', and 'primary' must be specified in allocation explain request", (Throwable)e, new Object[0]);
        }
        return req;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readOptionalString();
        this.shard = in.readOptionalVInt();
        this.primary = in.readOptionalBoolean();
        this.includeYesDecisions = in.readBoolean();
        this.includeDiskInfo = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.index);
        out.writeOptionalVInt(this.shard);
        out.writeOptionalBoolean(this.primary);
        out.writeBoolean(this.includeYesDecisions);
        out.writeBoolean(this.includeDiskInfo);
    }

    static {
        PARSER.declareString(ClusterAllocationExplainRequest::setIndex, new ParseField("index", new String[0]));
        PARSER.declareInt(ClusterAllocationExplainRequest::setShard, new ParseField("shard", new String[0]));
        PARSER.declareBoolean(ClusterAllocationExplainRequest::setPrimary, new ParseField("primary", new String[0]));
    }
}

