/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.bkd;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.bkd.OfflinePointReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.bkd.PointReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.bkd.PointWriter;

final class OfflinePointWriter
implements PointWriter {
    final Directory tempDir;
    final IndexOutput out;
    final String name;
    final int packedBytesLength;
    final boolean singleValuePerDoc;
    long count;
    private boolean closed;
    private boolean longOrds;
    private OfflinePointReader sharedReader;
    private long nextSharedRead;
    final long expectedCount;

    public OfflinePointWriter(Directory tempDir, String tempFileNamePrefix, int packedBytesLength, boolean longOrds, String desc, long expectedCount, boolean singleValuePerDoc) throws IOException {
        this.out = tempDir.createTempOutput(tempFileNamePrefix, "bkd_" + desc, IOContext.DEFAULT);
        this.name = this.out.getName();
        this.tempDir = tempDir;
        this.packedBytesLength = packedBytesLength;
        this.longOrds = longOrds;
        this.singleValuePerDoc = singleValuePerDoc;
        this.expectedCount = expectedCount;
    }

    public OfflinePointWriter(Directory tempDir, String name, int packedBytesLength, long count, boolean longOrds, boolean singleValuePerDoc) {
        this.out = null;
        this.name = name;
        this.tempDir = tempDir;
        this.packedBytesLength = packedBytesLength;
        this.count = count;
        this.closed = true;
        this.longOrds = longOrds;
        this.singleValuePerDoc = singleValuePerDoc;
        this.expectedCount = 0L;
    }

    @Override
    public void append(byte[] packedValue, long ord, int docID) throws IOException {
        assert (packedValue.length == this.packedBytesLength);
        this.out.writeBytes(packedValue, 0, packedValue.length);
        this.out.writeInt(docID);
        if (!this.singleValuePerDoc) {
            if (this.longOrds) {
                this.out.writeLong(ord);
            } else {
                assert (ord <= Integer.MAX_VALUE);
                this.out.writeInt((int)ord);
            }
        }
        ++this.count;
        assert (this.expectedCount == 0L || this.count <= this.expectedCount);
    }

    @Override
    public PointReader getReader(long start, long length) throws IOException {
        assert (this.closed);
        assert (start + length <= this.count) : "start=" + start + " length=" + length + " count=" + this.count;
        assert (this.expectedCount == 0L || this.count == this.expectedCount);
        return new OfflinePointReader(this.tempDir, this.name, this.packedBytesLength, start, length, this.longOrds, this.singleValuePerDoc);
    }

    @Override
    public PointReader getSharedReader(long start, long length, List<Closeable> toCloseHeroically) throws IOException {
        if (this.sharedReader == null) {
            assert (start == 0L);
            assert (length <= this.count);
            this.sharedReader = new OfflinePointReader(this.tempDir, this.name, this.packedBytesLength, 0L, this.count, this.longOrds, this.singleValuePerDoc);
            toCloseHeroically.add(this.sharedReader);
            assert (this.sharedReader.in instanceof ChecksumIndexInput);
        } else assert (start == this.nextSharedRead) : "start=" + start + " length=" + length + " nextSharedRead=" + this.nextSharedRead;
        this.nextSharedRead += length;
        return this.sharedReader;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            assert (this.sharedReader == null);
            try {
                CodecUtil.writeFooter(this.out);
            }
            finally {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void destroy() throws IOException {
        if (this.sharedReader != null) {
            assert (this.nextSharedRead == this.count);
            this.sharedReader.close();
            this.sharedReader = null;
        }
        this.tempDir.deleteFile(this.name);
    }

    public String toString() {
        return "OfflinePointWriter(count=" + this.count + " tempFileName=" + this.name + ")";
    }
}

