/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.bkd;

import java.io.EOFException;
import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.LongBitSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.bkd.OfflinePointWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.bkd.PointReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.bkd.PointWriter;

final class OfflinePointReader
extends PointReader {
    long countLeft;
    final IndexInput in;
    private final byte[] packedValue;
    final boolean singleValuePerDoc;
    final int bytesPerDoc;
    private long ord;
    private int docID;
    private boolean longOrds;
    private boolean checked;
    final String name;

    OfflinePointReader(Directory tempDir, String tempFileName, int packedBytesLength, long start, long length, boolean longOrds, boolean singleValuePerDoc) throws IOException {
        this.singleValuePerDoc = singleValuePerDoc;
        int bytesPerDoc = packedBytesLength + 4;
        if (!singleValuePerDoc) {
            bytesPerDoc = longOrds ? (bytesPerDoc += 8) : (bytesPerDoc += 4);
        }
        this.bytesPerDoc = bytesPerDoc;
        if ((start + length) * (long)bytesPerDoc + (long)CodecUtil.footerLength() > tempDir.fileLength(tempFileName)) {
            throw new IllegalArgumentException("requested slice is beyond the length of this file: start=" + start + " length=" + length + " bytesPerDoc=" + bytesPerDoc + " fileLength=" + tempDir.fileLength(tempFileName) + " tempFileName=" + tempFileName);
        }
        this.in = start == 0L && length * (long)bytesPerDoc == tempDir.fileLength(tempFileName) - (long)CodecUtil.footerLength() ? tempDir.openChecksumInput(tempFileName, IOContext.READONCE) : tempDir.openInput(tempFileName, IOContext.READONCE);
        this.name = tempFileName;
        long seekFP = start * (long)bytesPerDoc;
        this.in.seek(seekFP);
        this.countLeft = length;
        this.packedValue = new byte[packedBytesLength];
        this.longOrds = longOrds;
    }

    @Override
    public boolean next() throws IOException {
        if (this.countLeft >= 0L) {
            if (this.countLeft == 0L) {
                return false;
            }
            --this.countLeft;
        }
        try {
            this.in.readBytes(this.packedValue, 0, this.packedValue.length);
        }
        catch (EOFException eofe) {
            assert (this.countLeft == -1L);
            return false;
        }
        this.docID = this.in.readInt();
        this.ord = !this.singleValuePerDoc ? (this.longOrds ? this.in.readLong() : (long)this.in.readInt()) : (long)this.docID;
        return true;
    }

    @Override
    public byte[] packedValue() {
        return this.packedValue;
    }

    @Override
    public long ord() {
        return this.ord;
    }

    @Override
    public int docID() {
        return this.docID;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.countLeft == 0L && this.in instanceof ChecksumIndexInput && !this.checked) {
                this.checked = true;
                CodecUtil.checkFooter((ChecksumIndexInput)this.in);
            }
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public void markOrds(long count, LongBitSet ordBitSet) throws IOException {
        if (this.countLeft < count) {
            throw new IllegalStateException("only " + this.countLeft + " points remain, but " + count + " were requested");
        }
        long fp = this.in.getFilePointer() + (long)this.packedValue.length;
        if (!this.singleValuePerDoc) {
            fp += 4L;
        }
        for (long i = 0L; i < count; ++i) {
            this.in.seek(fp);
            long ord = this.longOrds ? this.in.readLong() : (long)this.in.readInt();
            assert (!ordBitSet.get(ord)) : "ord=" + ord + " i=" + i + " was seen twice from " + this;
            ordBitSet.set(ord);
            fp += (long)this.bytesPerDoc;
        }
    }

    @Override
    public long split(long count, LongBitSet rightTree, PointWriter left, PointWriter right, boolean doClearBits) throws IOException {
        if (!(left instanceof OfflinePointWriter) || !(right instanceof OfflinePointWriter)) {
            return super.split(count, rightTree, left, right, doClearBits);
        }
        int packedBytesLength = this.packedValue.length;
        int bytesPerDoc = packedBytesLength + 4;
        if (!this.singleValuePerDoc) {
            bytesPerDoc = this.longOrds ? (bytesPerDoc += 8) : (bytesPerDoc += 4);
        }
        long rightCount = 0L;
        IndexOutput rightOut = ((OfflinePointWriter)right).out;
        IndexOutput leftOut = ((OfflinePointWriter)left).out;
        assert (count <= this.countLeft) : "count=" + count + " countLeft=" + this.countLeft;
        this.countLeft -= count;
        long countStart = count;
        byte[] buffer = new byte[bytesPerDoc];
        while (count > 0L) {
            this.in.readBytes(buffer, 0, buffer.length);
            long ord = this.longOrds ? OfflinePointReader.readLong(buffer, packedBytesLength + 4) : (this.singleValuePerDoc ? (long)OfflinePointReader.readInt(buffer, packedBytesLength) : (long)OfflinePointReader.readInt(buffer, packedBytesLength + 4));
            if (rightTree.get(ord)) {
                rightOut.writeBytes(buffer, 0, bytesPerDoc);
                if (doClearBits) {
                    rightTree.clear(ord);
                }
                ++rightCount;
            } else {
                leftOut.writeBytes(buffer, 0, bytesPerDoc);
            }
            --count;
        }
        ((OfflinePointWriter)right).count = rightCount;
        ((OfflinePointWriter)left).count = countStart - rightCount;
        return rightCount;
    }

    private static long readLong(byte[] bytes, int pos) {
        int i1 = (bytes[pos++] & 0xFF) << 24 | (bytes[pos++] & 0xFF) << 16 | (bytes[pos++] & 0xFF) << 8 | bytes[pos++] & 0xFF;
        int i2 = (bytes[pos++] & 0xFF) << 24 | (bytes[pos++] & 0xFF) << 16 | (bytes[pos++] & 0xFF) << 8 | bytes[pos++] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    private static int readInt(byte[] bytes, int pos) {
        return (bytes[pos++] & 0xFF) << 24 | (bytes[pos++] & 0xFF) << 16 | (bytes[pos++] & 0xFF) << 8 | bytes[pos++] & 0xFF;
    }
}

