/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.search;

import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.geo.Polygon;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.geo.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.search.GeoPointInPolygonQueryImpl;

public final class GeoPointInPolygonQuery
extends GeoPointInBBoxQuery {
    final Polygon[] polygons;

    public GeoPointInPolygonQuery(String field, Polygon ... polygons) {
        this(field, GeoPointField.TermEncoding.PREFIX, polygons);
    }

    @Deprecated
    public GeoPointInPolygonQuery(String field, double[] polyLats, double[] polyLons) {
        this(field, GeoPointField.TermEncoding.PREFIX, polyLats, polyLons);
    }

    @Deprecated
    public GeoPointInPolygonQuery(String field, GeoPointField.TermEncoding termEncoding, double[] polyLats, double[] polyLons) {
        this(field, termEncoding, new Polygon(polyLats, polyLons, new Polygon[0]));
    }

    public GeoPointInPolygonQuery(String field, GeoPointField.TermEncoding termEncoding, Polygon ... polygons) {
        this(field, termEncoding, Rectangle.fromPolygon(polygons), polygons);
    }

    private GeoPointInPolygonQuery(String field, GeoPointField.TermEncoding termEncoding, Rectangle boundingBox, Polygon ... polygons) {
        super(field, termEncoding, boundingBox.minLat, boundingBox.maxLat, boundingBox.minLon, boundingBox.maxLon);
        this.polygons = (Polygon[])polygons.clone();
    }

    @Override
    public Query rewrite(IndexReader reader) {
        return new GeoPointInPolygonQueryImpl(this.field, this.termEncoding, this, this.minLat, this.maxLat, this.minLon, this.maxLon);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.polygons);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoPointInPolygonQuery other = (GeoPointInPolygonQuery)obj;
        return Arrays.equals(this.polygons, other.polygons);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.getField().equals(field)) {
            sb.append(" field=");
            sb.append(this.getField());
            sb.append(':');
        }
        sb.append(" Polygon: ");
        sb.append(Arrays.toString(this.polygons));
        return sb.toString();
    }

    public Polygon[] getPolygons() {
        return (Polygon[])this.polygons.clone();
    }
}

