/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.document;

import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Attribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.AttributeFactory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.AttributeImpl;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.AttributeReflector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefBuilder;

final class GeoPointTokenStream
extends TokenStream {
    private static final int MAX_SHIFT = 36;
    private final GeoPointTermAttribute geoPointTermAtt = this.addAttribute(GeoPointTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private boolean isInit = false;

    public GeoPointTokenStream() {
        super(new GeoPointAttributeFactory(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY));
    }

    public GeoPointTokenStream setGeoCode(long geoCode) {
        this.geoPointTermAtt.init(geoCode, 27);
        this.isInit = true;
        return this;
    }

    @Override
    public void reset() {
        if (!this.isInit) {
            throw new IllegalStateException("call setGeoCode() before usage");
        }
    }

    @Override
    public boolean incrementToken() {
        if (!this.isInit) {
            throw new IllegalStateException("call setGeoCode() before usage");
        }
        this.clearAttributes();
        int shift = this.geoPointTermAtt.incShift();
        this.posIncrAtt.setPositionIncrement(shift == 36 ? 1 : 0);
        return shift < 63;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(precisionStep=" + 9 + " shift=" + this.geoPointTermAtt.getShift() + ")";
    }

    public static final class GeoPointTermAttributeImpl
    extends AttributeImpl
    implements GeoPointTermAttribute,
    TermToBytesRefAttribute {
        private long value = 0L;
        private int shift = 27;
        private BytesRefBuilder bytes = new BytesRefBuilder();

        @Override
        public BytesRef getBytesRef() {
            GeoPointField.geoCodedToPrefixCoded(this.value, this.shift, this.bytes);
            return this.bytes.get();
        }

        @Override
        public void init(long value, int shift) {
            this.value = value;
            this.shift = shift;
        }

        @Override
        public int getShift() {
            return this.shift;
        }

        @Override
        public int incShift() {
            return this.shift += 9;
        }

        @Override
        public void clear() {
        }

        @Override
        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(TermToBytesRefAttribute.class, "bytes", this.getBytesRef());
            reflector.reflect(GeoPointTermAttribute.class, "shift", this.shift);
        }

        @Override
        public void copyTo(AttributeImpl target) {
            GeoPointTermAttribute a = (GeoPointTermAttribute)((Object)target);
            a.init(this.value, this.shift);
        }

        @Override
        public GeoPointTermAttributeImpl clone() {
            GeoPointTermAttributeImpl t = (GeoPointTermAttributeImpl)super.clone();
            t.bytes = new BytesRefBuilder();
            t.bytes.copyBytes(this.getBytesRef());
            return t;
        }

        public int hashCode() {
            return Objects.hash(this.shift, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeoPointTermAttributeImpl other = (GeoPointTermAttributeImpl)obj;
            if (this.shift != other.shift) {
                return false;
            }
            return this.value == other.value;
        }
    }

    private static final class GeoPointAttributeFactory
    extends AttributeFactory {
        private final AttributeFactory delegate;

        GeoPointAttributeFactory(AttributeFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            if (CharTermAttribute.class.isAssignableFrom(attClass)) {
                throw new IllegalArgumentException("GeoPointTokenStream does not support CharTermAttribute.");
            }
            return this.delegate.createAttributeInstance(attClass);
        }
    }

    public static interface GeoPointTermAttribute
    extends Attribute {
        public int getShift();

        public void init(long var1, int var3);

        public int incShift();
    }
}

