/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.bbox;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.DoubleDocValuesField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.DoublePoint;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.Field;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.LegacyDoubleField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.StoredField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.StringField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.SpatialStrategy;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.bbox.BBoxOverlapRatioValueSource;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.bbox.BBoxValueSource;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.util.DistanceToShapeValueSource;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.LegacyNumericUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.NumericUtils;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class BBoxStrategy
extends SpatialStrategy {
    public static FieldType DEFAULT_FIELDTYPE;
    @Deprecated
    public static FieldType LEGACY_FIELDTYPE;
    public static final String SUFFIX_MINX = "__minX";
    public static final String SUFFIX_MAXX = "__maxX";
    public static final String SUFFIX_MINY = "__minY";
    public static final String SUFFIX_MAXY = "__maxY";
    public static final String SUFFIX_XDL = "__xdl";
    final String field_bbox;
    final String field_minX;
    final String field_minY;
    final String field_maxX;
    final String field_maxY;
    final String field_xdl;
    private final FieldType optionsFieldType;
    private final int fieldsLen;
    private final boolean hasStored;
    private final boolean hasDocVals;
    private final boolean hasPointVals;
    private final FieldType legacyNumericFieldType;
    private final FieldType xdlFieldType;

    public static BBoxStrategy newInstance(SpatialContext ctx, String fieldNamePrefix) {
        return new BBoxStrategy(ctx, fieldNamePrefix, DEFAULT_FIELDTYPE);
    }

    @Deprecated
    public static BBoxStrategy newLegacyInstance(SpatialContext ctx, String fieldNamePrefix) {
        return new BBoxStrategy(ctx, fieldNamePrefix, LEGACY_FIELDTYPE);
    }

    public BBoxStrategy(SpatialContext ctx, String fieldNamePrefix, FieldType fieldType) {
        super(ctx, fieldNamePrefix);
        this.field_bbox = fieldNamePrefix;
        this.field_minX = fieldNamePrefix + SUFFIX_MINX;
        this.field_maxX = fieldNamePrefix + SUFFIX_MAXX;
        this.field_minY = fieldNamePrefix + SUFFIX_MINY;
        this.field_maxY = fieldNamePrefix + SUFFIX_MAXY;
        this.field_xdl = fieldNamePrefix + SUFFIX_XDL;
        fieldType.freeze();
        this.optionsFieldType = fieldType;
        int numQuads = 0;
        this.hasStored = fieldType.stored();
        if (this.hasStored) {
            ++numQuads;
        }
        if (this.hasDocVals = fieldType.docValuesType() != DocValuesType.NONE) {
            ++numQuads;
        }
        if (this.hasPointVals = fieldType.pointDimensionCount() > 0) {
            ++numQuads;
        }
        if (fieldType.indexOptions() != IndexOptions.NONE && fieldType.numericType() != null) {
            if (this.hasPointVals) {
                throw new IllegalArgumentException("pointValues and LegacyNumericType are mutually exclusive");
            }
            if (fieldType.numericType() != FieldType.LegacyNumericType.DOUBLE) {
                throw new IllegalArgumentException(this.getClass() + " does not support " + (Object)((Object)fieldType.numericType()));
            }
            ++numQuads;
            this.legacyNumericFieldType = new FieldType(LegacyDoubleField.TYPE_NOT_STORED);
            this.legacyNumericFieldType.setNumericPrecisionStep(fieldType.numericPrecisionStep());
            this.legacyNumericFieldType.freeze();
        } else {
            this.legacyNumericFieldType = null;
        }
        if (this.hasPointVals || this.legacyNumericFieldType != null) {
            this.xdlFieldType = new FieldType(StringField.TYPE_NOT_STORED);
            this.xdlFieldType.setIndexOptions(IndexOptions.DOCS);
            this.xdlFieldType.freeze();
        } else {
            this.xdlFieldType = null;
        }
        this.fieldsLen = numQuads * 4 + (this.xdlFieldType != null ? 1 : 0);
    }

    public FieldType getFieldType() {
        return this.optionsFieldType;
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        return this.createIndexableFields(shape.getBoundingBox());
    }

    private Field[] createIndexableFields(Rectangle bbox) {
        Field[] fields = new Field[this.fieldsLen];
        int idx = -1;
        if (this.hasStored) {
            fields[++idx] = new StoredField(this.field_minX, bbox.getMinX());
            fields[++idx] = new StoredField(this.field_minY, bbox.getMinY());
            fields[++idx] = new StoredField(this.field_maxX, bbox.getMaxX());
            fields[++idx] = new StoredField(this.field_maxY, bbox.getMaxY());
        }
        if (this.hasDocVals) {
            fields[++idx] = new DoubleDocValuesField(this.field_minX, bbox.getMinX());
            fields[++idx] = new DoubleDocValuesField(this.field_minY, bbox.getMinY());
            fields[++idx] = new DoubleDocValuesField(this.field_maxX, bbox.getMaxX());
            fields[++idx] = new DoubleDocValuesField(this.field_maxY, bbox.getMaxY());
        }
        if (this.hasPointVals) {
            fields[++idx] = new DoublePoint(this.field_minX, bbox.getMinX());
            fields[++idx] = new DoublePoint(this.field_minY, bbox.getMinY());
            fields[++idx] = new DoublePoint(this.field_maxX, bbox.getMaxX());
            fields[++idx] = new DoublePoint(this.field_maxY, bbox.getMaxY());
        }
        if (this.legacyNumericFieldType != null) {
            fields[++idx] = new LegacyDoubleField(this.field_minX, bbox.getMinX(), this.legacyNumericFieldType);
            fields[++idx] = new LegacyDoubleField(this.field_minY, bbox.getMinY(), this.legacyNumericFieldType);
            fields[++idx] = new LegacyDoubleField(this.field_maxX, bbox.getMaxX(), this.legacyNumericFieldType);
            fields[++idx] = new LegacyDoubleField(this.field_maxY, bbox.getMaxY(), this.legacyNumericFieldType);
        }
        if (this.xdlFieldType != null) {
            fields[++idx] = new Field(this.field_xdl, bbox.getCrossesDateLine() ? "T" : "F", this.xdlFieldType);
        }
        assert (idx == fields.length - 1);
        return fields;
    }

    public ValueSource makeShapeValueSource() {
        return new BBoxValueSource(this);
    }

    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        return new DistanceToShapeValueSource(this.makeShapeValueSource(), queryPoint, multiplier, this.ctx);
    }

    public ValueSource makeOverlapRatioValueSource(Rectangle queryBox, double queryTargetProportion) {
        return new BBoxOverlapRatioValueSource(this.makeShapeValueSource(), this.ctx.isGeo(), queryBox, queryTargetProportion, 0.0);
    }

    @Override
    public Query makeQuery(SpatialArgs args) {
        Query spatial;
        Shape shape = args.getShape();
        if (!(shape instanceof Rectangle)) {
            throw new UnsupportedOperationException("Can only query by Rectangle, not " + shape);
        }
        Rectangle bbox = (Rectangle)shape;
        SpatialOperation op = args.getOperation();
        if (op == SpatialOperation.BBoxIntersects) {
            spatial = this.makeIntersects(bbox);
        } else if (op == SpatialOperation.BBoxWithin) {
            spatial = this.makeWithin(bbox);
        } else if (op == SpatialOperation.Contains) {
            spatial = this.makeContains(bbox);
        } else if (op == SpatialOperation.Intersects) {
            spatial = this.makeIntersects(bbox);
        } else if (op == SpatialOperation.IsEqualTo) {
            spatial = this.makeEquals(bbox);
        } else if (op == SpatialOperation.IsDisjointTo) {
            spatial = this.makeDisjoint(bbox);
        } else if (op == SpatialOperation.IsWithin) {
            spatial = this.makeWithin(bbox);
        } else {
            throw new UnsupportedSpatialOperation(op);
        }
        return new ConstantScoreQuery(spatial);
    }

    Query makeContains(Rectangle bbox) {
        Query xConditions;
        Query qMinY = this.makeNumericRangeQuery(this.field_minY, null, bbox.getMinY(), false, true);
        Query qMaxY = this.makeNumericRangeQuery(this.field_maxY, bbox.getMaxY(), null, true, false);
        BooleanQuery yConditions = this.makeQuery(BooleanClause.Occur.MUST, qMinY, qMaxY);
        if (!bbox.getCrossesDateLine()) {
            Query qMinX = this.makeNumericRangeQuery(this.field_minX, null, bbox.getMinX(), false, true);
            Query qMaxX = this.makeNumericRangeQuery(this.field_maxX, bbox.getMaxX(), null, true, false);
            BooleanQuery qMinMax = this.makeQuery(BooleanClause.Occur.MUST, qMinX, qMaxX);
            Query qNonXDL = this.makeXDL(false, qMinMax);
            if (!this.ctx.isGeo()) {
                xConditions = qNonXDL;
            } else {
                Query qXDLLeft = this.makeNumericRangeQuery(this.field_minX, null, bbox.getMinX(), false, true);
                Query qXDLRight = this.makeNumericRangeQuery(this.field_maxX, bbox.getMaxX(), null, true, false);
                BooleanQuery qXDLLeftRight = this.makeQuery(BooleanClause.Occur.SHOULD, qXDLLeft, qXDLRight);
                Query qXDL = this.makeXDL(true, qXDLLeftRight);
                BooleanQuery qEdgeDL = null;
                if (bbox.getMinX() == bbox.getMaxX() && Math.abs(bbox.getMinX()) == 180.0) {
                    double edge = bbox.getMinX() * -1.0;
                    qEdgeDL = this.makeQuery(BooleanClause.Occur.SHOULD, this.makeNumberTermQuery(this.field_minX, edge), this.makeNumberTermQuery(this.field_maxX, edge));
                }
                xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qNonXDL, qXDL, qEdgeDL);
            }
        } else {
            Query qXDLLeft = this.makeNumericRangeQuery(this.field_minX, null, bbox.getMinX(), false, true);
            Query qXDLRight = this.makeNumericRangeQuery(this.field_maxX, bbox.getMaxX(), null, true, false);
            Query qXDLLeftRight = this.makeXDL(true, this.makeQuery(BooleanClause.Occur.MUST, qXDLLeft, qXDLRight));
            BooleanQuery qWorld = this.makeQuery(BooleanClause.Occur.MUST, this.makeNumberTermQuery(this.field_minX, -180.0), this.makeNumberTermQuery(this.field_maxX, 180.0));
            xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qXDLLeftRight, qWorld);
        }
        return this.makeQuery(BooleanClause.Occur.MUST, xConditions, yConditions);
    }

    Query makeDisjoint(Rectangle bbox) {
        Query xConditions;
        Query qMinY = this.makeNumericRangeQuery(this.field_minY, bbox.getMaxY(), null, false, false);
        Query qMaxY = this.makeNumericRangeQuery(this.field_maxY, null, bbox.getMinY(), false, false);
        BooleanQuery yConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qMinY, qMaxY);
        if (!bbox.getCrossesDateLine()) {
            Query qMinX = this.makeNumericRangeQuery(this.field_minX, bbox.getMaxX(), null, false, false);
            if (bbox.getMinX() == -180.0 && this.ctx.isGeo()) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(qMinX, BooleanClause.Occur.MUST);
                bq.add(this.makeNumberTermQuery(this.field_maxX, 180.0), BooleanClause.Occur.MUST_NOT);
                qMinX = bq.build();
            }
            Query qMaxX = this.makeNumericRangeQuery(this.field_maxX, null, bbox.getMinX(), false, false);
            if (bbox.getMaxX() == 180.0 && this.ctx.isGeo()) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(qMaxX, BooleanClause.Occur.MUST);
                bq.add(this.makeNumberTermQuery(this.field_minX, -180.0), BooleanClause.Occur.MUST_NOT);
                qMaxX = bq.build();
            }
            BooleanQuery qMinMax = this.makeQuery(BooleanClause.Occur.SHOULD, qMinX, qMaxX);
            Query qNonXDL = this.makeXDL(false, qMinMax);
            if (!this.ctx.isGeo()) {
                xConditions = qNonXDL;
            } else {
                Query qMinXLeft = this.makeNumericRangeQuery(this.field_minX, bbox.getMaxX(), null, false, false);
                Query qMaxXRight = this.makeNumericRangeQuery(this.field_maxX, null, bbox.getMinX(), false, false);
                BooleanQuery qLeftRight = this.makeQuery(BooleanClause.Occur.MUST, qMinXLeft, qMaxXRight);
                Query qXDL = this.makeXDL(true, qLeftRight);
                xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qNonXDL, qXDL);
            }
        } else {
            Query qMinXLeft = this.makeNumericRangeQuery(this.field_minX, 180.0, null, false, false);
            Query qMaxXLeft = this.makeNumericRangeQuery(this.field_maxX, null, bbox.getMinX(), false, false);
            Query qMinXRight = this.makeNumericRangeQuery(this.field_minX, bbox.getMaxX(), null, false, false);
            Query qMaxXRight = this.makeNumericRangeQuery(this.field_maxX, null, -180.0, false, false);
            BooleanQuery qLeft = this.makeQuery(BooleanClause.Occur.SHOULD, qMinXLeft, qMaxXLeft);
            BooleanQuery qRight = this.makeQuery(BooleanClause.Occur.SHOULD, qMinXRight, qMaxXRight);
            BooleanQuery qLeftRight = this.makeQuery(BooleanClause.Occur.MUST, qLeft, qRight);
            xConditions = this.makeXDL(false, qLeftRight);
        }
        return this.makeQuery(BooleanClause.Occur.SHOULD, xConditions, yConditions);
    }

    Query makeEquals(Rectangle bbox) {
        Query qMinX = this.makeNumberTermQuery(this.field_minX, bbox.getMinX());
        Query qMinY = this.makeNumberTermQuery(this.field_minY, bbox.getMinY());
        Query qMaxX = this.makeNumberTermQuery(this.field_maxX, bbox.getMaxX());
        Query qMaxY = this.makeNumberTermQuery(this.field_maxY, bbox.getMaxY());
        return this.makeQuery(BooleanClause.Occur.MUST, qMinX, qMinY, qMaxX, qMaxY);
    }

    Query makeIntersects(Rectangle bbox) {
        Query qHasEnv;
        if (this.ctx.isGeo()) {
            Query qIsNonXDL = this.makeXDL(false);
            Query qIsXDL = this.ctx.isGeo() ? this.makeXDL(true) : null;
            qHasEnv = this.makeQuery(BooleanClause.Occur.SHOULD, qIsNonXDL, qIsXDL);
        } else {
            qHasEnv = this.makeXDL(false);
        }
        BooleanQuery.Builder qNotDisjoint = new BooleanQuery.Builder();
        qNotDisjoint.add(qHasEnv, BooleanClause.Occur.MUST);
        Query qDisjoint = this.makeDisjoint(bbox);
        qNotDisjoint.add(qDisjoint, BooleanClause.Occur.MUST_NOT);
        return qNotDisjoint.build();
    }

    BooleanQuery makeQuery(BooleanClause.Occur occur, Query ... queries) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (Query query : queries) {
            if (query == null) continue;
            bq.add(query, occur);
        }
        return bq.build();
    }

    Query makeWithin(Rectangle bbox) {
        Query xConditions;
        Query qMinY = this.makeNumericRangeQuery(this.field_minY, bbox.getMinY(), null, true, false);
        Query qMaxY = this.makeNumericRangeQuery(this.field_maxY, null, bbox.getMaxY(), false, true);
        BooleanQuery yConditions = this.makeQuery(BooleanClause.Occur.MUST, qMinY, qMaxY);
        if (this.ctx.isGeo() && bbox.getMinX() == -180.0 && bbox.getMaxX() == 180.0) {
            return yConditions;
        }
        if (!bbox.getCrossesDateLine()) {
            Query qMinX = this.makeNumericRangeQuery(this.field_minX, bbox.getMinX(), null, true, false);
            Query qMaxX = this.makeNumericRangeQuery(this.field_maxX, null, bbox.getMaxX(), false, true);
            BooleanQuery qMinMax = this.makeQuery(BooleanClause.Occur.MUST, qMinX, qMaxX);
            double edge = 0.0;
            if (bbox.getMinX() == -180.0) {
                edge = 180.0;
            } else if (bbox.getMaxX() == 180.0) {
                edge = -180.0;
            }
            if (edge != 0.0 && this.ctx.isGeo()) {
                BooleanQuery edgeQ = this.makeQuery(BooleanClause.Occur.MUST, this.makeNumberTermQuery(this.field_minX, edge), this.makeNumberTermQuery(this.field_maxX, edge));
                qMinMax = this.makeQuery(BooleanClause.Occur.SHOULD, qMinMax, edgeQ);
            }
            xConditions = this.makeXDL(false, qMinMax);
        } else {
            Query qMinXLeft = this.makeNumericRangeQuery(this.field_minX, bbox.getMinX(), null, true, false);
            Query qMaxXLeft = this.makeNumericRangeQuery(this.field_maxX, null, 180.0, false, true);
            BooleanQuery qLeft = this.makeQuery(BooleanClause.Occur.MUST, qMinXLeft, qMaxXLeft);
            Query qMinXRight = this.makeNumericRangeQuery(this.field_minX, -180.0, null, true, false);
            Query qMaxXRight = this.makeNumericRangeQuery(this.field_maxX, null, bbox.getMaxX(), false, true);
            BooleanQuery qRight = this.makeQuery(BooleanClause.Occur.MUST, qMinXRight, qMaxXRight);
            BooleanQuery qLeftRight = this.makeQuery(BooleanClause.Occur.SHOULD, qLeft, qRight);
            Query qNonXDL = this.makeXDL(false, qLeftRight);
            Query qXDLLeft = this.makeNumericRangeQuery(this.field_minX, bbox.getMinX(), null, true, false);
            Query qXDLRight = this.makeNumericRangeQuery(this.field_maxX, null, bbox.getMaxX(), false, true);
            BooleanQuery qXDLLeftRight = this.makeQuery(BooleanClause.Occur.MUST, qXDLLeft, qXDLRight);
            Query qXDL = this.makeXDL(true, qXDLLeftRight);
            xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qNonXDL, qXDL);
        }
        return this.makeQuery(BooleanClause.Occur.MUST, xConditions, yConditions);
    }

    private Query makeXDL(boolean crossedDateLine) {
        return new TermQuery(new Term(this.field_xdl, crossedDateLine ? "T" : "F"));
    }

    private Query makeXDL(boolean crossedDateLine, Query query) {
        if (!this.ctx.isGeo()) {
            assert (!crossedDateLine);
            return query;
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add(this.makeXDL(crossedDateLine), BooleanClause.Occur.MUST);
        bq.add(query, BooleanClause.Occur.MUST);
        return bq.build();
    }

    private Query makeNumberTermQuery(String field, double number) {
        if (this.hasPointVals) {
            return DoublePoint.newExactQuery(field, number);
        }
        if (this.legacyNumericFieldType != null) {
            BytesRefBuilder bytes = new BytesRefBuilder();
            LegacyNumericUtils.longToPrefixCoded(NumericUtils.doubleToSortableLong(number), 0, bytes);
            return new TermQuery(new Term(field, bytes.get()));
        }
        throw new UnsupportedOperationException("An index is required for this operation.");
    }

    private Query makeNumericRangeQuery(String fieldname, Double min, Double max, boolean minInclusive, boolean maxInclusive) {
        if (this.hasPointVals) {
            if (min == null) {
                min = Double.NEGATIVE_INFINITY;
            }
            if (max == null) {
                max = Double.POSITIVE_INFINITY;
            }
            if (!minInclusive) {
                min = Math.nextUp(min);
            }
            if (!maxInclusive) {
                max = Math.nextDown(max);
            }
            return DoublePoint.newRangeQuery(fieldname, min, max);
        }
        if (this.legacyNumericFieldType != null) {
            return LegacyNumericRangeQuery.newDoubleRange(fieldname, this.legacyNumericFieldType.numericPrecisionStep(), min, max, minInclusive, maxInclusive);
        }
        throw new UnsupportedOperationException("An index is required for this operation.");
    }

    static {
        FieldType type = new FieldType();
        type.setDimensions(1, 8);
        type.setDocValuesType(DocValuesType.NUMERIC);
        type.setStored(false);
        type.freeze();
        DEFAULT_FIELDTYPE = type;
        type = new FieldType();
        type.setIndexOptions(IndexOptions.DOCS);
        type.setNumericType(FieldType.LegacyNumericType.DOUBLE);
        type.setNumericPrecisionStep(8);
        type.setDocValuesType(DocValuesType.NUMERIC);
        type.setStored(false);
        type.freeze();
        LEGACY_FIELDTYPE = type;
    }
}

