/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.FieldsConsumer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.FieldsProducer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.PostingsFormat;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentReadState;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document.CompletionFieldsConsumer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document.CompletionFieldsProducer;

public abstract class CompletionPostingsFormat
extends PostingsFormat {
    static final String CODEC_NAME = "completion";
    static final int COMPLETION_CODEC_VERSION = 1;
    static final int COMPLETION_VERSION_CURRENT = 1;
    static final String INDEX_EXTENSION = "cmp";
    static final String DICT_EXTENSION = "lkp";

    public CompletionPostingsFormat() {
        super(CODEC_NAME);
    }

    protected abstract PostingsFormat delegatePostingsFormat();

    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        PostingsFormat delegatePostingsFormat = this.delegatePostingsFormat();
        if (delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + this.getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        return new CompletionFieldsConsumer(delegatePostingsFormat, state);
    }

    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new CompletionFieldsProducer(state);
    }
}

