/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FilterWeight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join.BitSetProducer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join.ScoreMode;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BitSet;

public class ToParentBlockJoinQuery
extends Query {
    private final BitSetProducer parentsFilter;
    private final Query childQuery;
    private final Query origChildQuery;
    private final ScoreMode scoreMode;

    public ToParentBlockJoinQuery(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = childQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    private ToParentBlockJoinQuery(Query origChildQuery, Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = origChildQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new BlockJoinWeight(this, this.childQuery.createWeight(searcher, needsScores), this.parentsFilter, needsScores ? this.scoreMode : ScoreMode.None);
    }

    public Query getChildQuery() {
        return this.childQuery;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query childRewrite = this.childQuery.rewrite(reader);
        if (childRewrite != this.childQuery) {
            return new ToParentBlockJoinQuery(this.origChildQuery, childRewrite, this.parentsFilter, this.scoreMode);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        return "ToParentBlockJoinQuery (" + this.childQuery.toString() + ")";
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((ToParentBlockJoinQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(ToParentBlockJoinQuery other) {
        return this.origChildQuery.equals(other.origChildQuery) && this.parentsFilter.equals(other.parentsFilter) && this.scoreMode == other.scoreMode;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = this.classHash();
        hash = 31 * hash + this.origChildQuery.hashCode();
        hash = 31 * hash + this.scoreMode.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    static class BlockJoinScorer
    extends ChildrenMatchesScorer {
        private final Scorer childScorer;
        private final BitSet parentBits;
        private final ScoreMode scoreMode;
        private int parentDoc = -1;
        private int prevParentDoc;
        private float parentScore;
        private int parentFreq;
        private int nextChildDoc;
        private int[] pendingChildDocs;
        private float[] pendingChildScores;
        private int childDocUpto;

        public BlockJoinScorer(Weight weight, Scorer childScorer, BitSet parentBits, int firstChildDoc, ScoreMode scoreMode) {
            super(weight);
            this.parentBits = parentBits;
            this.childScorer = childScorer;
            this.scoreMode = scoreMode;
            this.nextChildDoc = firstChildDoc;
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.childScorer, "BLOCK_JOIN"));
        }

        @Override
        public int getChildCount() {
            return this.childDocUpto;
        }

        int getParentDoc() {
            return this.parentDoc;
        }

        @Override
        public int[] swapChildDocs(int[] other) {
            int[] ret = this.pendingChildDocs;
            this.pendingChildDocs = other == null ? new int[5] : other;
            return ret;
        }

        float[] swapChildScores(float[] other) {
            if (this.scoreMode == ScoreMode.None) {
                throw new IllegalStateException("ScoreMode is None; you must pass trackScores=false to ToParentBlockJoinCollector");
            }
            float[] ret = this.pendingChildScores;
            this.pendingChildScores = other == null ? new float[5] : other;
            return ret;
        }

        @Override
        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){
                final DocIdSetIterator childIt;
                {
                    this.childIt = childScorer.iterator();
                }

                @Override
                public int nextDoc() throws IOException {
                    if (nextChildDoc == Integer.MAX_VALUE) {
                        return parentDoc = Integer.MAX_VALUE;
                    }
                    parentDoc = parentBits.nextSetBit(nextChildDoc);
                    this.checkOrthogonal(nextChildDoc, parentDoc);
                    assert (parentDoc != Integer.MAX_VALUE);
                    float totalScore = 0.0f;
                    float maxScore = Float.NEGATIVE_INFINITY;
                    float minScore = Float.POSITIVE_INFINITY;
                    childDocUpto = 0;
                    parentFreq = 0;
                    do {
                        if (pendingChildDocs != null && pendingChildDocs.length == childDocUpto) {
                            BlockJoinScorer.access$702(this, ArrayUtil.grow(pendingChildDocs));
                        }
                        if (pendingChildScores != null && scoreMode != ScoreMode.None && pendingChildScores.length == childDocUpto) {
                            BlockJoinScorer.access$802(this, ArrayUtil.grow(pendingChildScores));
                        }
                        if (pendingChildDocs != null) {
                            ((BlockJoinScorer)this).pendingChildDocs[((BlockJoinScorer)this).childDocUpto] = nextChildDoc;
                        }
                        if (scoreMode != ScoreMode.None) {
                            float childScore = childScorer.score();
                            int childFreq = childScorer.freq();
                            if (pendingChildScores != null) {
                                ((BlockJoinScorer)this).pendingChildScores[((BlockJoinScorer)this).childDocUpto] = childScore;
                            }
                            maxScore = Math.max(childScore, maxScore);
                            minScore = Math.min(childScore, minScore);
                            totalScore += childScore;
                            parentFreq = parentFreq + childFreq;
                        }
                        childDocUpto++;
                        nextChildDoc = this.childIt.nextDoc();
                    } while (nextChildDoc < parentDoc);
                    this.checkOrthogonal(nextChildDoc, parentDoc);
                    switch (scoreMode) {
                        case Avg: {
                            parentScore = totalScore / (float)childDocUpto;
                            break;
                        }
                        case Max: {
                            parentScore = maxScore;
                            break;
                        }
                        case Min: {
                            parentScore = minScore;
                            break;
                        }
                        case Total: {
                            parentScore = totalScore;
                            break;
                        }
                    }
                    return parentDoc;
                }

                @Override
                public int advance(int parentTarget) throws IOException {
                    if (parentTarget == Integer.MAX_VALUE) {
                        return parentDoc = Integer.MAX_VALUE;
                    }
                    if (parentTarget == 0) {
                        return this.nextDoc();
                    }
                    prevParentDoc = parentBits.prevSetBit(parentTarget - 1);
                    assert (prevParentDoc >= parentDoc);
                    if (prevParentDoc > nextChildDoc) {
                        nextChildDoc = this.childIt.advance(prevParentDoc);
                    }
                    this.checkOrthogonal(nextChildDoc, prevParentDoc);
                    int nd = this.nextDoc();
                    return nd;
                }

                @Override
                public int docID() {
                    return parentDoc;
                }

                @Override
                public long cost() {
                    return this.childIt.cost();
                }
            };
        }

        private void checkOrthogonal(int childDoc, int parentDoc) {
            if (childDoc == parentDoc) {
                throw new IllegalStateException("Child query must not match same docs with parent filter. Combine them as must clauses (+) to find a problem doc. docId=" + this.nextChildDoc + ", " + this.childScorer.getClass());
            }
        }

        @Override
        public int docID() {
            return this.parentDoc;
        }

        @Override
        public float score() throws IOException {
            return this.parentScore;
        }

        @Override
        public int freq() {
            return this.parentFreq;
        }

        public Explanation explain(LeafReaderContext context, Weight childWeight) throws IOException {
            int start = context.docBase + this.prevParentDoc + 1;
            int end = context.docBase + this.parentDoc - 1;
            Explanation bestChild = null;
            int matches = 0;
            for (int childDoc = start; childDoc <= end; ++childDoc) {
                Explanation child = childWeight.explain(context, childDoc - context.docBase);
                if (!child.isMatch()) continue;
                ++matches;
                if (bestChild != null && !(child.getValue() > bestChild.getValue())) continue;
                bestChild = child;
            }
            return Explanation.match(this.score(), String.format(Locale.ROOT, "Score based on %d child docs in range from %d to %d, best match:", matches, start, end), bestChild);
        }

        @Override
        public void trackPendingChildHits() {
            this.pendingChildDocs = new int[5];
            if (this.scoreMode != ScoreMode.None) {
                this.pendingChildScores = new float[5];
            }
        }

        static /* synthetic */ int[] access$702(BlockJoinScorer x0, int[] x1) {
            x0.pendingChildDocs = x1;
            return x1;
        }

        static /* synthetic */ float[] access$802(BlockJoinScorer x0, float[] x1) {
            x0.pendingChildScores = x1;
            return x1;
        }
    }

    public static abstract class ChildrenMatchesScorer
    extends Scorer {
        protected ChildrenMatchesScorer(Weight weight) {
            super(weight);
        }

        public abstract void trackPendingChildHits();

        public abstract int getChildCount();

        public abstract int[] swapChildDocs(int[] var1);
    }

    private static class BlockJoinWeight
    extends FilterWeight {
        private final BitSetProducer parentsFilter;
        private final ScoreMode scoreMode;

        public BlockJoinWeight(Query joinQuery, Weight childWeight, BitSetProducer parentsFilter, ScoreMode scoreMode) {
            super(joinQuery, childWeight);
            this.parentsFilter = parentsFilter;
            this.scoreMode = scoreMode;
        }

        @Override
        public Scorer scorer(LeafReaderContext readerContext) throws IOException {
            Scorer childScorer = this.in.scorer(readerContext);
            if (childScorer == null) {
                return null;
            }
            int firstChildDoc = childScorer.iterator().nextDoc();
            if (firstChildDoc == Integer.MAX_VALUE) {
                return null;
            }
            BitSet parents = this.parentsFilter.getBitSet(readerContext);
            if (parents == null) {
                return null;
            }
            return new BlockJoinScorer(this, childScorer, parents, firstChildDoc, this.scoreMode);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            BlockJoinScorer scorer = (BlockJoinScorer)this.scorer(context);
            if (scorer != null && scorer.iterator().advance(doc) == doc) {
                return scorer.explain(context, this.in);
            }
            return Explanation.noMatch("Not a match", new Explanation[0]);
        }
    }
}

