/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join.DocValuesTermsCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join.ScoreMode;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join.TermsCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join.TermsWithScoreCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefHash;

interface GenericTermsCollector
extends Collector {
    public BytesRefHash getCollectedTerms();

    public float[] getScoresPerTerm();

    public static GenericTermsCollector createCollectorMV(DocValuesTermsCollector.Function<SortedSetDocValues> mvFunction, ScoreMode mode) {
        switch (mode) {
            case None: {
                return GenericTermsCollector.wrap(new TermsCollector.MV(mvFunction));
            }
            case Avg: {
                return new TermsWithScoreCollector.MV.Avg(mvFunction);
            }
        }
        return new TermsWithScoreCollector.MV(mvFunction, mode);
    }

    public static DocValuesTermsCollector.Function<SortedSetDocValues> verbose(final PrintStream out, DocValuesTermsCollector.Function<SortedSetDocValues> mvFunction) {
        return ctx -> {
            final SortedSetDocValues target = (SortedSetDocValues)mvFunction.apply(ctx);
            return new SortedSetDocValues(){

                @Override
                public void setDocument(int docID) {
                    target.setDocument(docID);
                    out.println("\ndoc# " + docID);
                }

                @Override
                public long nextOrd() {
                    return target.nextOrd();
                }

                @Override
                public BytesRef lookupOrd(long ord) {
                    BytesRef val = target.lookupOrd(ord);
                    out.println(val.toString() + ", ");
                    return val;
                }

                @Override
                public long getValueCount() {
                    return target.getValueCount();
                }
            };
        };
    }

    public static GenericTermsCollector createCollectorSV(DocValuesTermsCollector.Function<BinaryDocValues> svFunction, ScoreMode mode) {
        switch (mode) {
            case None: {
                return GenericTermsCollector.wrap(new TermsCollector.SV(svFunction));
            }
            case Avg: {
                return new TermsWithScoreCollector.SV.Avg(svFunction);
            }
        }
        return new TermsWithScoreCollector.SV(svFunction, mode);
    }

    public static GenericTermsCollector wrap(final TermsCollector<?> collector) {
        return new GenericTermsCollector(){

            @Override
            public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
                return collector.getLeafCollector(context);
            }

            @Override
            public boolean needsScores() {
                return collector.needsScores();
            }

            @Override
            public BytesRefHash getCollectedTerms() {
                return collector.getCollectorTerms();
            }

            @Override
            public float[] getScoresPerTerm() {
                throw new UnsupportedOperationException("scores are not available for " + collector);
            }
        };
    }
}

