/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.FunctionValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FilterScorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;

public final class BoostedQuery
extends Query {
    private final Query q;
    private final ValueSource boostVal;

    public BoostedQuery(Query subQuery, ValueSource boostVal) {
        this.q = subQuery;
        this.boostVal = boostVal;
    }

    public Query getQuery() {
        return this.q;
    }

    public ValueSource getValueSource() {
        return this.boostVal;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.q.rewrite(reader);
        if (newQ != this.q) {
            return new BoostedQuery(newQ, this.boostVal);
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new BoostedWeight(searcher, needsScores);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("boost(").append(this.q.toString(field)).append(',').append(this.boostVal).append(')');
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((BoostedQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(BoostedQuery other) {
        return this.q.equals(other.q) && this.boostVal.equals(other.boostVal);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.q.hashCode();
        h = 31 * h + this.boostVal.hashCode();
        return h;
    }

    private class CustomScorer
    extends FilterScorer {
        private final BoostedWeight weight;
        private final FunctionValues vals;
        private final LeafReaderContext readerContext;

        private CustomScorer(LeafReaderContext readerContext, BoostedWeight w, Scorer scorer, ValueSource vs) throws IOException {
            super(scorer);
            this.weight = w;
            this.readerContext = readerContext;
            this.vals = vs.getValues(this.weight.fcontext, readerContext);
        }

        @Override
        public float score() throws IOException {
            float score = this.in.score() * this.vals.floatVal(this.in.docID());
            return score > Float.NEGATIVE_INFINITY ? score : -3.4028235E38f;
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.in, "CUSTOM"));
        }

        public Explanation explain(int doc) throws IOException {
            Explanation subQueryExpl = this.weight.qWeight.explain(this.readerContext, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            float sc = subQueryExpl.getValue() * this.vals.floatVal(doc);
            return Explanation.match(sc, BoostedQuery.this.toString() + ", product of:", subQueryExpl, this.vals.explain(doc));
        }
    }

    private class BoostedWeight
    extends Weight {
        Weight qWeight;
        Map fcontext;

        public BoostedWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            super(BoostedQuery.this);
            this.qWeight = searcher.createWeight(BoostedQuery.this.q, needsScores);
            this.fcontext = ValueSource.newContext(searcher);
            BoostedQuery.this.boostVal.createWeight(this.fcontext, searcher);
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.qWeight.extractTerms(terms);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.qWeight.getValueForNormalization();
        }

        @Override
        public void normalize(float norm, float boost) {
            this.qWeight.normalize(norm, boost);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer subQueryScorer = this.qWeight.scorer(context);
            if (subQueryScorer == null) {
                return null;
            }
            return new CustomScorer(context, this, subQueryScorer, BoostedQuery.this.boostVal);
        }

        @Override
        public Explanation explain(LeafReaderContext readerContext, int doc) throws IOException {
            Explanation subQueryExpl = this.qWeight.explain(readerContext, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            FunctionValues vals = BoostedQuery.this.boostVal.getValues(this.fcontext, readerContext);
            float sc = subQueryExpl.getValue() * vals.floatVal(doc);
            return Explanation.match(sc, BoostedQuery.this.toString() + ", product of:", subQueryExpl, vals.explain(doc));
        }
    }
}

