/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.NormsConsumer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.packed.PackedLongValues;

class NormValuesWriter {
    private static final long MISSING = 0L;
    private PackedLongValues.Builder pending = PackedLongValues.deltaPackedBuilder(0.0f);
    private final Counter iwBytesUsed;
    private long bytesUsed = this.pending.ramBytesUsed();
    private final FieldInfo fieldInfo;

    public NormValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        for (int i = (int)this.pending.size(); i < docID; ++i) {
            this.pending.add(0L);
        }
        this.pending.add(value);
        this.updateBytesUsed();
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    public void finish(int maxDoc) {
    }

    public void flush(SegmentWriteState state, NormsConsumer normsConsumer) throws IOException {
        final int maxDoc = state.segmentInfo.maxDoc();
        final PackedLongValues values = this.pending.build();
        normsConsumer.addNormsField(this.fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new NumericIterator(maxDoc, values);
            }
        });
    }

    private static class NumericIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final int size;
        final int maxDoc;
        int upto;

        NumericIterator(int maxDoc, PackedLongValues values) {
            this.maxDoc = maxDoc;
            this.iter = values.iterator();
            this.size = (int)values.size();
        }

        @Override
        public boolean hasNext() {
            return this.upto < this.maxDoc;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Long value = this.upto < this.size ? Long.valueOf(this.iter.next()) : Long.valueOf(0L);
            ++this.upto;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

