/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MultiBits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MultiFields;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MultiTermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.ReaderSlice;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.ReaderUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Accountables;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.LongValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.packed.PackedInts;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.packed.PackedLongValues;

public class MultiDocValues {
    private MultiDocValues() {
    }

    public static NumericDocValues getNormValues(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getNormValues(field);
        }
        FieldInfo fi = MultiFields.getMergedFieldInfos(r).fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        boolean anyReal = false;
        final NumericDocValues[] values = new NumericDocValues[size];
        final int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            NumericDocValues v = context.reader().getNormValues(field);
            if (v == null) {
                v = DocValues.emptyNumeric();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        assert (anyReal);
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts);
                return values[subIndex].get(docID - starts[subIndex]);
            }
        };
    }

    public static NumericDocValues getNumericValues(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getNumericDocValues(field);
        }
        boolean anyReal = false;
        final NumericDocValues[] values = new NumericDocValues[size];
        final int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            NumericDocValues v = context.reader().getNumericDocValues(field);
            if (v == null) {
                v = DocValues.emptyNumeric();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts);
                return values[subIndex].get(docID - starts[subIndex]);
            }
        };
    }

    public static Bits getDocsWithField(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getDocsWithField(field);
        }
        boolean anyReal = false;
        boolean anyMissing = false;
        Bits[] values = new Bits[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            Bits v = context.reader().getDocsWithField(field);
            if (v == null) {
                v = new Bits.MatchNoBits(context.reader().maxDoc());
                anyMissing = true;
            } else {
                anyReal = true;
                if (!(v instanceof Bits.MatchAllBits)) {
                    anyMissing = true;
                }
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        if (!anyMissing) {
            return new Bits.MatchAllBits(r.maxDoc());
        }
        return new MultiBits(values, starts, false);
    }

    public static BinaryDocValues getBinaryValues(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getBinaryDocValues(field);
        }
        boolean anyReal = false;
        final BinaryDocValues[] values = new BinaryDocValues[size];
        final int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            BinaryDocValues v = context.reader().getBinaryDocValues(field);
            if (v == null) {
                v = DocValues.emptyBinary();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new BinaryDocValues(){

            @Override
            public BytesRef get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts);
                return values[subIndex].get(docID - starts[subIndex]);
            }
        };
    }

    public static SortedNumericDocValues getSortedNumericValues(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedNumericDocValues(field);
        }
        boolean anyReal = false;
        final SortedNumericDocValues[] values = new SortedNumericDocValues[size];
        final int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedNumericDocValues v = context.reader().getSortedNumericDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedNumeric(context.reader().maxDoc());
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new SortedNumericDocValues(){
            SortedNumericDocValues current;

            @Override
            public void setDocument(int doc) {
                int subIndex = ReaderUtil.subIndex(doc, starts);
                this.current = values[subIndex];
                this.current.setDocument(doc - starts[subIndex]);
            }

            @Override
            public long valueAt(int index) {
                return this.current.valueAt(index);
            }

            @Override
            public int count() {
                return this.current.count();
            }
        };
    }

    public static SortedDocValues getSortedValues(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedDocValues(field);
        }
        boolean anyReal = false;
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedDocValues v = context.reader().getSortedDocValues(field);
            if (v == null) {
                v = DocValues.emptySorted();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        OrdinalMap mapping = OrdinalMap.build(r.getCoreCacheKey(), values, 0.25f);
        return new MultiSortedDocValues(values, starts, mapping);
    }

    public static SortedSetDocValues getSortedSetValues(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedSetDocValues(field);
        }
        boolean anyReal = false;
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedSetDocValues v = context.reader().getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            } else {
                anyReal = true;
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        OrdinalMap mapping = OrdinalMap.build(r.getCoreCacheKey(), values, 0.25f);
        return new MultiSortedSetDocValues(values, starts, mapping);
    }

    public static class MultiSortedSetDocValues
    extends SortedSetDocValues {
        public final int[] docStarts;
        public final SortedSetDocValues[] values;
        public final OrdinalMap mapping;
        int currentSubIndex;
        LongValues currentGlobalOrds;

        public MultiSortedSetDocValues(SortedSetDocValues[] values, int[] docStarts, OrdinalMap mapping) throws IOException {
            assert (docStarts.length == values.length + 1);
            this.values = values;
            this.docStarts = docStarts;
            this.mapping = mapping;
        }

        @Override
        public long nextOrd() {
            long segmentOrd = this.values[this.currentSubIndex].nextOrd();
            if (segmentOrd == -1L) {
                return segmentOrd;
            }
            return this.currentGlobalOrds.get(segmentOrd);
        }

        @Override
        public void setDocument(int docID) {
            this.currentSubIndex = ReaderUtil.subIndex(docID, this.docStarts);
            this.currentGlobalOrds = this.mapping.getGlobalOrds(this.currentSubIndex);
            this.values[this.currentSubIndex].setDocument(docID - this.docStarts[this.currentSubIndex]);
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            long segmentOrd = this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public long getValueCount() {
            return this.mapping.getValueCount();
        }
    }

    public static class MultiSortedDocValues
    extends SortedDocValues {
        public final int[] docStarts;
        public final SortedDocValues[] values;
        public final OrdinalMap mapping;

        public MultiSortedDocValues(SortedDocValues[] values, int[] docStarts, OrdinalMap mapping) throws IOException {
            assert (docStarts.length == values.length + 1);
            this.values = values;
            this.docStarts = docStarts;
            this.mapping = mapping;
        }

        @Override
        public int getOrd(int docID) {
            int subIndex = ReaderUtil.subIndex(docID, this.docStarts);
            int segmentOrd = this.values[subIndex].getOrd(docID - this.docStarts[subIndex]);
            return segmentOrd == -1 ? segmentOrd : (int)this.mapping.getGlobalOrds(subIndex).get(segmentOrd);
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            int segmentOrd = (int)this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public int getValueCount() {
            return (int)this.mapping.getValueCount();
        }
    }

    public static class OrdinalMap
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OrdinalMap.class);
        public final Object owner;
        final PackedLongValues globalOrdDeltas;
        final PackedLongValues firstSegments;
        final LongValues[] segmentToGlobalOrds;
        final SegmentMap segmentMap;
        final long ramBytesUsed;

        public static OrdinalMap build(Object owner, SortedDocValues[] values, float acceptableOverheadRatio) throws IOException {
            TermsEnum[] subs = new TermsEnum[values.length];
            long[] weights = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                subs[i] = values[i].termsEnum();
                weights[i] = values[i].getValueCount();
            }
            return OrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
        }

        public static OrdinalMap build(Object owner, SortedSetDocValues[] values, float acceptableOverheadRatio) throws IOException {
            TermsEnum[] subs = new TermsEnum[values.length];
            long[] weights = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                subs[i] = values[i].termsEnum();
                weights[i] = values[i].getValueCount();
            }
            return OrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
        }

        public static OrdinalMap build(Object owner, TermsEnum[] subs, long[] weights, float acceptableOverheadRatio) throws IOException {
            if (subs.length != weights.length) {
                throw new IllegalArgumentException("subs and weights must have the same length");
            }
            SegmentMap segmentMap = new SegmentMap(weights);
            return new OrdinalMap(owner, subs, segmentMap, acceptableOverheadRatio);
        }

        OrdinalMap(Object owner, TermsEnum[] subs, SegmentMap segmentMap, float acceptableOverheadRatio) throws IOException {
            this.owner = owner;
            this.segmentMap = segmentMap;
            PackedLongValues.Builder globalOrdDeltas = PackedLongValues.monotonicBuilder(0.0f);
            PackedLongValues.Builder firstSegments = PackedLongValues.packedBuilder(0.0f);
            PackedLongValues.Builder[] ordDeltas = new PackedLongValues.Builder[subs.length];
            for (int i = 0; i < ordDeltas.length; ++i) {
                ordDeltas[i] = PackedLongValues.monotonicBuilder(acceptableOverheadRatio);
            }
            long[] ordDeltaBits = new long[subs.length];
            long[] segmentOrds = new long[subs.length];
            ReaderSlice[] slices = new ReaderSlice[subs.length];
            MultiTermsEnum.TermsEnumIndex[] indexes = new MultiTermsEnum.TermsEnumIndex[slices.length];
            for (int i = 0; i < slices.length; ++i) {
                slices[i] = new ReaderSlice(0, 0, i);
                indexes[i] = new MultiTermsEnum.TermsEnumIndex(subs[segmentMap.newToOld(i)], i);
            }
            MultiTermsEnum mte = new MultiTermsEnum(slices);
            mte.reset(indexes);
            long globalOrd = 0L;
            while (mte.next() != null) {
                MultiTermsEnum.TermsEnumWithSlice[] matches = mte.getMatchArray();
                int firstSegmentIndex = Integer.MAX_VALUE;
                long globalOrdDelta = Long.MAX_VALUE;
                for (int i = 0; i < mte.getMatchCount(); ++i) {
                    int segmentIndex = matches[i].index;
                    long segmentOrd = matches[i].terms.ord();
                    long delta = globalOrd - segmentOrd;
                    if (segmentIndex < firstSegmentIndex) {
                        firstSegmentIndex = segmentIndex;
                        globalOrdDelta = delta;
                    }
                    while (segmentOrds[segmentIndex] <= segmentOrd) {
                        int n = segmentIndex;
                        ordDeltaBits[n] = ordDeltaBits[n] | delta;
                        ordDeltas[segmentIndex].add(delta);
                        int n2 = segmentIndex;
                        segmentOrds[n2] = segmentOrds[n2] + 1L;
                    }
                }
                assert (firstSegmentIndex < segmentOrds.length);
                firstSegments.add(firstSegmentIndex);
                globalOrdDeltas.add(globalOrdDelta);
                ++globalOrd;
            }
            this.firstSegments = firstSegments.build();
            this.globalOrdDeltas = globalOrdDeltas.build();
            this.segmentToGlobalOrds = new LongValues[subs.length];
            long ramBytesUsed = BASE_RAM_BYTES_USED + this.globalOrdDeltas.ramBytesUsed() + this.firstSegments.ramBytesUsed() + RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds) + segmentMap.ramBytesUsed();
            for (int i = 0; i < ordDeltas.length; ++i) {
                final PackedLongValues deltas = ordDeltas[i].build();
                if (ordDeltaBits[i] == 0L) {
                    this.segmentToGlobalOrds[i] = LongValues.IDENTITY;
                    continue;
                }
                int bitsRequired = ordDeltaBits[i] < 0L ? 64 : PackedInts.bitsRequired(ordDeltaBits[i]);
                long monotonicBits = deltas.ramBytesUsed() * 8L;
                long packedBits = (long)bitsRequired * deltas.size();
                if (deltas.size() <= Integer.MAX_VALUE && (float)packedBits <= (float)monotonicBits * (1.0f + acceptableOverheadRatio)) {
                    int size = (int)deltas.size();
                    final PackedInts.Mutable newDeltas = PackedInts.getMutable(size, bitsRequired, acceptableOverheadRatio);
                    PackedLongValues.Iterator it = deltas.iterator();
                    for (int ord = 0; ord < size; ++ord) {
                        newDeltas.set(ord, it.next());
                    }
                    assert (!it.hasNext());
                    this.segmentToGlobalOrds[i] = new LongValues(){

                        @Override
                        public long get(long ord) {
                            return ord + newDeltas.get((int)ord);
                        }
                    };
                    ramBytesUsed += newDeltas.ramBytesUsed();
                } else {
                    this.segmentToGlobalOrds[i] = new LongValues(){

                        @Override
                        public long get(long ord) {
                            return ord + deltas.get(ord);
                        }
                    };
                    ramBytesUsed += deltas.ramBytesUsed();
                }
                ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds[i]);
            }
            this.ramBytesUsed = ramBytesUsed;
        }

        public LongValues getGlobalOrds(int segmentIndex) {
            return this.segmentToGlobalOrds[this.segmentMap.oldToNew(segmentIndex)];
        }

        public long getFirstSegmentOrd(long globalOrd) {
            return globalOrd - this.globalOrdDeltas.get(globalOrd);
        }

        public int getFirstSegmentNumber(long globalOrd) {
            return this.segmentMap.newToOld((int)this.firstSegments.get(globalOrd));
        }

        public long getValueCount() {
            return this.globalOrdDeltas.size();
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("global ord deltas", this.globalOrdDeltas));
            resources.add(Accountables.namedAccountable("first segments", this.firstSegments));
            resources.add(Accountables.namedAccountable("segment map", this.segmentMap));
            return resources;
        }

        private static class SegmentMap
        implements Accountable {
            private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentMap.class);
            private final int[] newToOld;
            private final int[] oldToNew;

            private static int[] map(final long[] weights) {
                final int[] newToOld = new int[weights.length];
                for (int i = 0; i < weights.length; ++i) {
                    newToOld[i] = i;
                }
                new InPlaceMergeSorter(){

                    @Override
                    protected void swap(int i, int j) {
                        int tmp = newToOld[i];
                        newToOld[i] = newToOld[j];
                        newToOld[j] = tmp;
                    }

                    @Override
                    protected int compare(int i, int j) {
                        return Long.compare(weights[newToOld[j]], weights[newToOld[i]]);
                    }
                }.sort(0, weights.length);
                return newToOld;
            }

            private static int[] inverse(int[] map) {
                int[] inverse = new int[map.length];
                for (int i = 0; i < map.length; ++i) {
                    inverse[map[i]] = i;
                }
                return inverse;
            }

            SegmentMap(long[] weights) {
                this.newToOld = SegmentMap.map(weights);
                this.oldToNew = SegmentMap.inverse(this.newToOld);
                assert (Arrays.equals(this.newToOld, SegmentMap.inverse(this.oldToNew)));
            }

            int newToOld(int segment) {
                return this.newToOld[segment];
            }

            int oldToNew(int segment) {
                return this.oldToNew[segment];
            }

            @Override
            public long ramBytesUsed() {
                return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.newToOld) + RamUsageEstimator.sizeOf(this.oldToNew);
            }
        }
    }
}

