/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.LatLonDocValuesField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.geo.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.LeafFieldComparator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.SloppyMath;

class LatLonPointDistanceComparator
extends FieldComparator<Double>
implements LeafFieldComparator {
    final String field;
    final double latitude;
    final double longitude;
    final double[] values;
    double bottom;
    double topValue;
    SortedNumericDocValues currentDocs;
    int minLon = Integer.MIN_VALUE;
    int maxLon = Integer.MAX_VALUE;
    int minLat = Integer.MIN_VALUE;
    int maxLat = Integer.MAX_VALUE;
    int minLon2 = Integer.MAX_VALUE;
    int setBottomCounter = 0;

    public LatLonPointDistanceComparator(String field, double latitude, double longitude, int numHits) {
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.values = new double[numHits];
    }

    @Override
    public void setScorer(Scorer scorer) {
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setBottom(int slot) {
        this.bottom = this.values[slot];
        if (this.setBottomCounter < 1024 || (this.setBottomCounter & 0x3F) == 63) {
            Rectangle box = Rectangle.fromPointDistance(this.latitude, this.longitude, LatLonPointDistanceComparator.haversin2(this.bottom));
            this.minLat = GeoEncodingUtils.encodeLatitude(box.minLat);
            this.maxLat = GeoEncodingUtils.encodeLatitude(box.maxLat);
            if (box.crossesDateline()) {
                this.minLon = Integer.MIN_VALUE;
                this.maxLon = GeoEncodingUtils.encodeLongitude(box.maxLon);
                this.minLon2 = GeoEncodingUtils.encodeLongitude(box.minLon);
            } else {
                this.minLon = GeoEncodingUtils.encodeLongitude(box.minLon);
                this.maxLon = GeoEncodingUtils.encodeLongitude(box.maxLon);
                this.minLon2 = Integer.MAX_VALUE;
            }
        }
        ++this.setBottomCounter;
    }

    @Override
    public void setTopValue(Double value) {
        this.topValue = value;
    }

    @Override
    public int compareBottom(int doc) throws IOException {
        this.currentDocs.setDocument(doc);
        int numValues = this.currentDocs.count();
        if (numValues == 0) {
            return Double.compare(this.bottom, Double.POSITIVE_INFINITY);
        }
        int cmp = -1;
        for (int i = 0; i < numValues; ++i) {
            double docLongitude;
            double docLatitude;
            int longitudeBits;
            long encoded = this.currentDocs.valueAt(i);
            int latitudeBits = (int)(encoded >> 32);
            if (latitudeBits < this.minLat || latitudeBits > this.maxLat || ((longitudeBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL)) < this.minLon || longitudeBits > this.maxLon) && longitudeBits < this.minLon2 || (cmp = Math.max(cmp, Double.compare(this.bottom, SloppyMath.haversinSortKey(this.latitude, this.longitude, docLatitude = GeoEncodingUtils.decodeLatitude(latitudeBits), docLongitude = GeoEncodingUtils.decodeLongitude(longitudeBits))))) <= 0) continue;
            return cmp;
        }
        return cmp;
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.sortKey(doc);
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.field);
        if (info != null) {
            LatLonDocValuesField.checkCompatible(info);
        }
        this.currentDocs = DocValues.getSortedNumeric(reader, this.field);
        return this;
    }

    @Override
    public Double value(int slot) {
        return LatLonPointDistanceComparator.haversin2(this.values[slot]);
    }

    @Override
    public int compareTop(int doc) throws IOException {
        return Double.compare(this.topValue, LatLonPointDistanceComparator.haversin2(this.sortKey(doc)));
    }

    double sortKey(int doc) {
        this.currentDocs.setDocument(doc);
        double minValue = Double.POSITIVE_INFINITY;
        int numValues = this.currentDocs.count();
        for (int i = 0; i < numValues; ++i) {
            long encoded = this.currentDocs.valueAt(i);
            double docLatitude = GeoEncodingUtils.decodeLatitude((int)(encoded >> 32));
            double docLongitude = GeoEncodingUtils.decodeLongitude((int)(encoded & 0xFFFFFFFFFFFFFFFFL));
            minValue = Math.min(minValue, SloppyMath.haversinSortKey(this.latitude, this.longitude, docLatitude, docLongitude));
        }
        return minValue;
    }

    static double haversin2(double partial) {
        if (Double.isInfinite(partial)) {
            return partial;
        }
        return SloppyMath.haversinMeters(partial);
    }
}

