/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.logging.InternalLogger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.util.ThreadNameDeterminer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.util.ThreadRenamingRunnable;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.transport.netty3.ChannelBufferBytesReference;
import org.elasticsearch.transport.netty3.Netty3InternalESLogger;

public class Netty3Utils {
    public static final boolean DEFAULT_GATHERING = true;
    private static EsThreadNameDeterminer ES_THREAD_NAME_DETERMINER = new EsThreadNameDeterminer();

    public static void setup() {
    }

    public static ChannelBuffer toChannelBuffer(BytesReference reference) {
        if (reference.length() == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (reference instanceof ChannelBufferBytesReference) {
            return ((ChannelBufferBytesReference)reference).toChannelBuffer();
        }
        BytesRefIterator iterator = reference.iterator();
        ArrayList<ChannelBuffer> buffers = new ArrayList<ChannelBuffer>();
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                buffers.add(ChannelBuffers.wrappedBuffer(slice.bytes, slice.offset, slice.length));
            }
            return ChannelBuffers.wrappedBuffer(true, buffers.toArray(new ChannelBuffer[buffers.size()]));
        }
        catch (IOException ex) {
            throw new AssertionError("no IO happens here", ex);
        }
    }

    public static BytesReference toBytesReference(ChannelBuffer channelBuffer) {
        return Netty3Utils.toBytesReference(channelBuffer, channelBuffer.readableBytes());
    }

    public static BytesReference toBytesReference(ChannelBuffer channelBuffer, int size) {
        return new ChannelBufferBytesReference(channelBuffer, size);
    }

    public static void maybeDie(Throwable cause) {
        if (cause instanceof Error) {
            try {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String formatted = Arrays.stream(stackTrace).skip(1L).map(e -> "\tat " + e).collect(Collectors.joining("\n"));
                ESLoggerFactory.getLogger(Netty3Utils.class).error("fatal error on the network layer\n{}", (Object)formatted);
            }
            finally {
                new Thread(() -> {
                    throw (Error)cause;
                }).start();
            }
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory(new InternalLoggerFactory(){

            @Override
            public InternalLogger newInstance(String name) {
                return new Netty3InternalESLogger(Loggers.getLogger(name));
            }
        });
        ThreadRenamingRunnable.setThreadNameDeterminer(ES_THREAD_NAME_DETERMINER);
        String key = "sun.nio.ch.bugLevel";
        String buglevel = System.getProperty("sun.nio.ch.bugLevel");
        if (buglevel == null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    @SuppressForbidden(reason="to use System#setProperty to set sun.nio.ch.bugLevel")
                    public Void run() {
                        System.setProperty("sun.nio.ch.bugLevel", "");
                        return null;
                    }
                });
            }
            catch (SecurityException e) {
                Loggers.getLogger(Netty3Utils.class).debug(() -> new ParameterizedMessage("Unable to get/set System Property: {}", (Object)"sun.nio.ch.bugLevel"), (Throwable)e);
            }
        }
    }

    public static class EsThreadNameDeterminer
    implements ThreadNameDeterminer {
        @Override
        public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
            return currentThreadName + "{" + proposedThreadName + "}";
        }
    }
}

