/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreSearchContext;

public class RescorePhase
extends AbstractComponent
implements SearchPhase {
    public RescorePhase(Settings settings) {
        super(settings);
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        try {
            TopDocs topDocs = context.queryResult().topDocs();
            for (RescoreSearchContext ctx : context.rescore()) {
                topDocs = ctx.rescorer().rescore(topDocs, context, ctx);
            }
            context.queryResult().topDocs(topDocs, context.queryResult().sortValueFormats());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Rescore Phase Failed", (Throwable)e, new Object[0]);
        }
    }
}

