/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.path.PathTrie;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.DeprecationRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;

public class RestController
extends AbstractLifecycleComponent {
    private final PathTrie<RestHandler> getHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> postHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> putHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> deleteHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> headHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> optionsHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final RestHandlerFilter handlerFilter = new RestHandlerFilter();
    private final Set<String> headersToCopy;
    private RestFilter[] filters = new RestFilter[0];

    public RestController(Settings settings, Set<String> headersToCopy) {
        super(settings);
        this.headersToCopy = headersToCopy;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        for (RestFilter filter : this.filters) {
            filter.close();
        }
    }

    public synchronized void registerFilter(RestFilter preProcessor) {
        RestFilter[] copy = new RestFilter[this.filters.length + 1];
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        copy[this.filters.length] = preProcessor;
        Arrays.sort(copy, (o1, o2) -> Integer.compare(o1.order(), o2.order()));
        this.filters = copy;
    }

    public void registerAsDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, String deprecationMessage, DeprecationLogger logger) {
        assert (!(handler instanceof DeprecationRestHandler));
        this.registerHandler(method, path, new DeprecationRestHandler(handler, deprecationMessage, logger));
    }

    public void registerWithDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, RestRequest.Method deprecatedMethod, String deprecatedPath, DeprecationLogger logger) {
        String deprecationMessage = "[" + deprecatedMethod.name() + " " + deprecatedPath + "] is deprecated! Use [" + method.name() + " " + path + "] instead.";
        this.registerHandler(method, path, handler);
        this.registerAsDeprecatedHandler(deprecatedMethod, deprecatedPath, handler, deprecationMessage, logger);
    }

    public void registerHandler(RestRequest.Method method, String path, RestHandler handler) {
        PathTrie<RestHandler> handlers = this.getHandlersForMethod(method);
        if (handlers == null) {
            throw new IllegalArgumentException("Can't handle [" + (Object)((Object)method) + "] for path [" + path + "]");
        }
        handlers.insert(path, handler);
    }

    @Nullable
    public RestFilterChain filterChainOrNull(RestFilter executionFilter) {
        if (this.filters.length == 0) {
            return null;
        }
        return new ControllerFilterChain(executionFilter);
    }

    public RestFilterChain filterChain(RestFilter executionFilter) {
        return new ControllerFilterChain(executionFilter);
    }

    public boolean canTripCircuitBreaker(RestRequest request) {
        RestHandler handler = this.getHandler(request);
        return handler != null ? handler.canTripCircuitBreaker() : true;
    }

    public void dispatchRequest(RestRequest request, RestChannel channel, NodeClient client, ThreadContext threadContext) throws Exception {
        if (!this.checkRequestParameters(request, channel)) {
            return;
        }
        try (ThreadContext.StoredContext ignored = threadContext.stashContext();){
            for (String key : this.headersToCopy) {
                String httpHeader = request.header(key);
                if (httpHeader == null) continue;
                threadContext.putHeader(key, httpHeader);
            }
            if (this.filters.length == 0) {
                this.executeHandler(request, channel, client);
            } else {
                ControllerFilterChain filterChain = new ControllerFilterChain(this.handlerFilter);
                filterChain.continueProcessing(request, channel, client);
            }
        }
    }

    public void sendErrorResponse(RestRequest request, RestChannel channel, Exception e) {
        try {
            channel.sendResponse(new BytesRestResponse(channel, e));
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            this.logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
        }
    }

    boolean checkRequestParameters(RestRequest request, RestChannel channel) {
        if (request.paramAsBoolean("error_trace", false) && !channel.detailedErrorsEnabled()) {
            try {
                XContentBuilder builder = channel.newErrorBuilder();
                builder.startObject().field("error", "error traces in responses are disabled.").endObject().string();
                BytesRestResponse response = new BytesRestResponse(RestStatus.BAD_REQUEST, builder);
                response.addHeader("Content-Type", "application/json");
                channel.sendResponse(response);
            }
            catch (IOException e) {
                this.logger.warn("Failed to send response", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    void executeHandler(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        RestHandler handler = this.getHandler(request);
        if (handler != null) {
            handler.handleRequest(request, channel, client);
        } else if (request.method() == RestRequest.Method.OPTIONS) {
            channel.sendResponse(new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        } else {
            String msg = "No handler found for uri [" + request.uri() + "] and method [" + (Object)((Object)request.method()) + "]";
            channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, msg));
        }
    }

    private RestHandler getHandler(RestRequest request) {
        String path = this.getPath(request);
        PathTrie<RestHandler> handlers = this.getHandlersForMethod(request.method());
        if (handlers != null) {
            return handlers.retrieve(path, request.params());
        }
        return null;
    }

    private PathTrie<RestHandler> getHandlersForMethod(RestRequest.Method method) {
        if (method == RestRequest.Method.GET) {
            return this.getHandlers;
        }
        if (method == RestRequest.Method.POST) {
            return this.postHandlers;
        }
        if (method == RestRequest.Method.PUT) {
            return this.putHandlers;
        }
        if (method == RestRequest.Method.DELETE) {
            return this.deleteHandlers;
        }
        if (method == RestRequest.Method.HEAD) {
            return this.headHandlers;
        }
        if (method == RestRequest.Method.OPTIONS) {
            return this.optionsHandlers;
        }
        return null;
    }

    private String getPath(RestRequest request) {
        return request.rawPath();
    }

    class RestHandlerFilter
    extends RestFilter {
        RestHandlerFilter() {
        }

        @Override
        public void process(RestRequest request, RestChannel channel, NodeClient client, RestFilterChain filterChain) throws Exception {
            RestController.this.executeHandler(request, channel, client);
        }
    }

    class ControllerFilterChain
    implements RestFilterChain {
        private final RestFilter executionFilter;
        private final AtomicInteger index = new AtomicInteger();

        ControllerFilterChain(RestFilter executionFilter) {
            this.executionFilter = executionFilter;
        }

        @Override
        public void continueProcessing(RestRequest request, RestChannel channel, NodeClient client) {
            try {
                int loc = this.index.getAndIncrement();
                if (loc > RestController.this.filters.length) {
                    throw new IllegalStateException("filter continueProcessing was called more than expected");
                }
                if (loc == RestController.this.filters.length) {
                    this.executionFilter.process(request, channel, client, this);
                } else {
                    RestFilter preProcessor = RestController.this.filters[loc];
                    preProcessor.process(request, channel, client, this);
                }
            }
            catch (Exception e) {
                try {
                    channel.sendResponse(new BytesRestResponse(channel, e));
                }
                catch (IOException e1) {
                    RestController.this.logger.error(() -> new ParameterizedMessage("Failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)e1);
                }
            }
        }
    }
}

