/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.ReaderUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;

public final class PercolatorHighlightSubFetchPhase
extends HighlightPhase {
    public PercolatorHighlightSubFetchPhase(Settings settings, Map<String, Highlighter> highlighters) {
        super(settings, highlighters);
    }

    boolean hitsExecutionNeeded(SearchContext context) {
        return context.highlight() != null && PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query()) != null;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) {
        if (!this.hitsExecutionNeeded(context)) {
            return;
        }
        PercolateQuery percolateQuery = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(context.query());
        if (percolateQuery == null) {
            throw new IllegalStateException("couldn't locate percolator query");
        }
        List<LeafReaderContext> ctxs = context.searcher().getIndexReader().leaves();
        IndexSearcher percolatorIndexSearcher = percolateQuery.getPercolatorIndexSearcher();
        PercolateQuery.QueryStore queryStore = percolateQuery.getQueryStore();
        LeafReaderContext percolatorLeafReaderContext = percolatorIndexSearcher.getIndexReader().leaves().get(0);
        FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext();
        SubSearchContext subSearchContext = this.createSubSearchContext(context, percolatorLeafReaderContext, percolateQuery.getDocumentSource());
        for (InternalSearchHit hit : hits) {
            Query query;
            try {
                LeafReaderContext ctx = ctxs.get(ReaderUtil.subIndex(hit.docId(), ctxs));
                int segmentDocId = hit.docId() - ctx.docBase;
                query = queryStore.getQueries(ctx).getQuery(segmentDocId);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (query == null) continue;
            subSearchContext.parsedQuery(new ParsedQuery(query));
            hitContext.reset(new InternalSearchHit(0, "unknown", new Text(percolateQuery.getDocumentType()), Collections.emptyMap()), percolatorLeafReaderContext, 0, percolatorIndexSearcher);
            hitContext.cache().clear();
            super.hitExecute(subSearchContext, hitContext);
            hit.highlightFields().putAll(hitContext.hit().getHighlightFields());
        }
    }

    static PercolateQuery locatePercolatorQuery(Query query) {
        if (query instanceof PercolateQuery) {
            return (PercolateQuery)query;
        }
        if (query instanceof BooleanQuery) {
            for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
                PercolateQuery result = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(clause.getQuery());
                if (result == null) continue;
                return result;
            }
        } else if (query instanceof DisjunctionMaxQuery) {
            for (Query disjunct : ((DisjunctionMaxQuery)query).getDisjuncts()) {
                PercolateQuery result = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(disjunct);
                if (result == null) continue;
                return result;
            }
        } else {
            if (query instanceof ConstantScoreQuery) {
                return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((ConstantScoreQuery)query).getQuery());
            }
            if (query instanceof BoostQuery) {
                return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((BoostQuery)query).getQuery());
            }
            if (query instanceof FunctionScoreQuery) {
                return PercolatorHighlightSubFetchPhase.locatePercolatorQuery(((FunctionScoreQuery)query).getSubQuery());
            }
        }
        return null;
    }

    private SubSearchContext createSubSearchContext(SearchContext context, LeafReaderContext leafReaderContext, BytesReference source) {
        SubSearchContext subSearchContext = new SubSearchContext(context);
        subSearchContext.highlight(new SearchContextHighlight(context.highlight().fields()));
        subSearchContext.highlight().globalForceSource(true);
        subSearchContext.lookup().source().setSegmentAndDocument(leafReaderContext, 0);
        subSearchContext.lookup().source().setSource(source);
        return subSearchContext;
    }
}

