/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

class RecoveryResponse
extends TransportResponse {
    List<String> phase1FileNames = new ArrayList<String>();
    List<Long> phase1FileSizes = new ArrayList<Long>();
    List<String> phase1ExistingFileNames = new ArrayList<String>();
    List<Long> phase1ExistingFileSizes = new ArrayList<Long>();
    long phase1TotalSize;
    long phase1ExistingTotalSize;
    long phase1Time;
    long phase1ThrottlingWaitTime;
    long startTime;
    int phase2Operations;
    long phase2Time;

    RecoveryResponse() {
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        int size = in.readVInt();
        this.phase1FileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1FileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileSizes.add(in.readVLong());
        }
        size = in.readVInt();
        this.phase1ExistingFileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1ExistingFileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileSizes.add(in.readVLong());
        }
        this.phase1TotalSize = in.readVLong();
        this.phase1ExistingTotalSize = in.readVLong();
        this.phase1Time = in.readVLong();
        this.phase1ThrottlingWaitTime = in.readVLong();
        this.startTime = in.readVLong();
        this.phase2Operations = in.readVInt();
        this.phase2Time = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        long size;
        super.writeTo(out);
        out.writeVInt(this.phase1FileNames.size());
        for (String name : this.phase1FileNames) {
            out.writeString(name);
        }
        out.writeVInt(this.phase1FileSizes.size());
        Iterator<Object> iterator = this.phase1FileSizes.iterator();
        while (iterator.hasNext()) {
            size = (Long)iterator.next();
            out.writeVLong(size);
        }
        out.writeVInt(this.phase1ExistingFileNames.size());
        for (String name : this.phase1ExistingFileNames) {
            out.writeString(name);
        }
        out.writeVInt(this.phase1ExistingFileSizes.size());
        iterator = this.phase1ExistingFileSizes.iterator();
        while (iterator.hasNext()) {
            size = (Long)iterator.next();
            out.writeVLong(size);
        }
        out.writeVLong(this.phase1TotalSize);
        out.writeVLong(this.phase1ExistingTotalSize);
        out.writeVLong(this.phase1Time);
        out.writeVLong(this.phase1ThrottlingWaitTime);
        out.writeVLong(this.startTime);
        out.writeVInt(this.phase2Operations);
        out.writeVLong(this.phase2Time);
    }
}

